/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.generation;

import ai.vespa.json.Json;
import com.fasterxml.jackson.core.JsonFactory;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.json.DocumentOperationType;
import com.yahoo.document.json.JsonReader;
import com.yahoo.document.json.ParsedDocumentOperation;
import com.yahoo.text.Utf8;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

class FieldGeneratorUtils {
    FieldGeneratorUtils() {
    }

    public static String generateJsonSchemaForField(String fieldPath, DataType fieldType) {
        Json.Builder.Object fieldValue;
        Json.Builder.Object schema = Json.Builder.newObject().set("type", "object");
        Json.Builder.Object properties = schema.setObject("properties");
        try {
            fieldValue = FieldGeneratorUtils.generateJsonSchemaForFieldValue(fieldType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to generate schema for field %s of type %s".formatted(fieldPath, fieldType.getName()), e);
        }
        properties.set(fieldPath, fieldValue);
        Json.Builder.Array required = schema.setArray("required");
        required.add(fieldPath);
        schema.set("additionalProperties", false);
        return schema.build().toJson(true);
    }

    private static Json.Builder.Object generateJsonSchemaForFieldValue(DataType fieldType) {
        Json.Builder.Object field = Json.Builder.newObject();
        if (fieldType.equals((Object)DataType.BOOL)) {
            field.set("type", "boolean");
        } else if (fieldType.equals((Object)DataType.STRING)) {
            field.set("type", "string");
        } else if (fieldType.equals((Object)DataType.INT) || fieldType.equals((Object)DataType.LONG) || fieldType.equals((Object)DataType.BYTE)) {
            field.set("type", "integer");
        } else if (fieldType.equals((Object)DataType.FLOAT) || fieldType.equals((Object)DataType.DOUBLE) || fieldType.equals((Object)DataType.FLOAT16)) {
            field.set("type", "number");
        } else if (fieldType instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)fieldType;
            field.set("type", "array");
            Json.Builder.Object itemsValue = FieldGeneratorUtils.generateJsonSchemaForFieldValue(arrayType.getNestedType());
            field.set("items", itemsValue);
        } else if (fieldType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)fieldType;
            field.set("type", "object");
            Json.Builder.Object value = FieldGeneratorUtils.generateJsonSchemaForFieldValue(mapType.getValueType());
            field.set("additionalProperties", value);
        } else if (fieldType instanceof WeightedSetDataType) {
            field.set("type", "object");
            Json.Builder.Object additionalProperties = field.setObject("additionalProperties");
            additionalProperties.set("type", "integer");
        } else if (fieldType instanceof StructDataType) {
            StructDataType structType = (StructDataType)fieldType;
            field.set("type", "object");
            Json.Builder.Object properties = field.setObject("properties");
            Json.Builder.Array required = field.setArray("required");
            field.set("additionalProperties", false);
            for (Field structField : structType.getFields()) {
                String fieldName = structField.getName();
                Json.Builder.Object fieldValue = FieldGeneratorUtils.generateJsonSchemaForFieldValue(structField.getDataType());
                properties.set(fieldName, fieldValue);
                required.add(fieldName);
            }
        } else {
            throw new IllegalArgumentException("Failed to generate schema for field type %s".formatted(fieldType));
        }
        return field;
    }

    public static FieldValue parseJsonFieldValue(String jsonFieldValue, String fieldPath, DataType fieldType) {
        ParsedDocumentOperation parsedDocumentOperation;
        String documentTypeName = "dummy";
        String documentId = "id:generate:%s::0".formatted(documentTypeName);
        String jsonDocumentOperation = "{\n    \"put\": \"%s\",\n    \"fields\": %s\n}\n".formatted(documentId, jsonFieldValue);
        DocumentTypeManager types = new DocumentTypeManager();
        DocumentType docType = new DocumentType(documentTypeName);
        Field field = new Field(fieldPath, fieldType);
        docType.addField(field);
        types.registerDocumentType(docType);
        JsonFactory parserFactory = new JsonFactory();
        ByteArrayInputStream input = new ByteArrayInputStream(Utf8.toBytes((String)jsonDocumentOperation));
        JsonReader jsonReader = new JsonReader(types, (InputStream)input, parserFactory);
        try {
            parsedDocumentOperation = jsonReader.readSingleDocumentStreaming(DocumentOperationType.PUT, documentId);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to parse JSON value for field %s of type %s: %s".formatted(fieldPath, fieldType.getName(), jsonFieldValue), e);
        }
        DocumentPut documentOperation = (DocumentPut)parsedDocumentOperation.operation();
        Document document = documentOperation.getDocument();
        return document.getFieldValue(field);
    }
}

