/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.docs;

import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.set.MetricSet;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;

public class MetricSetDocumentation {
    protected static void writeMetricSetDocumentation(String path, String name, MetricSet metricSet, Map<String, VespaMetrics[]> metricsByType) {
        Map<String, LinkedHashSet> groupedBySuffix = metricSet.getMetrics().keySet().stream().map(MetricSetDocumentation::withSuffix).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toCollection(LinkedHashSet::new))));
        LinkedHashMap metricTypeByName = metricsByType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.stream((VespaMetrics[])entry.getValue()).filter(val -> groupedBySuffix.containsKey(val.baseName())).collect(Collectors.toMap(val -> val, val -> (LinkedHashSet)groupedBySuffix.get(val.baseName()), (a, b) -> a, LinkedHashMap::new)), (a, b) -> a, LinkedHashMap::new));
        StringBuilder referenceBuilder = new StringBuilder();
        referenceBuilder.append(String.format("---\n# Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.\n# Note: This file is generated by\n# https://github.com/vespa-engine/vespa/blob/master/metrics/src/main/java/ai/vespa/metrics/docs/MetricSetDocumentation.java\ntitle: \"%s Metric Set\"\n---\n<p>\n    This document provides reference documentation for the %s metric set, including suffixes present per metric.\n    If the suffix column contains \"N/A\" then the base name of the corresponding metric is used with no suffix.\n</p>", name, name));
        metricsByType.keySet().stream().sorted().filter(m -> !((LinkedHashMap)metricTypeByName.get(m)).isEmpty()).forEach(type -> referenceBuilder.append(String.format("\n<h2 id=\"%s-metrics\">%s Metrics</h2>\n<table class=\"table\">\n  <thead>\n     <tr><th>Name</th><th>Unit</th><th>Suffixes</th><th>Description</th></tr>\n  </thead>\n  <tbody>\n %s  </tbody>\n</table>\n", type.toLowerCase(), type, MetricSetDocumentation.htmlRows((Map)metricTypeByName.get(type)))));
        try (FileWriter fileWriter = new FileWriter(path + "/" + metricSet.getId().toLowerCase() + "-set-metrics-reference.html");){
            fileWriter.write(referenceBuilder.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String htmlRows(Map<VespaMetrics, LinkedHashSet<String>> metrics) {
        return metrics.entrySet().stream().map(entry -> String.format("   <tr>\n      <td><p id=\"%s\">%s</p></td>\n      <td>%s</td>\n      <td>%s</td>\n      <td>%s</td>\n   </tr>\n", ((VespaMetrics)entry.getKey()).baseName().replaceAll("\\.", "_"), ((VespaMetrics)entry.getKey()).baseName(), ((VespaMetrics)entry.getKey()).unit().toString().toLowerCase(), String.join((CharSequence)", ", (Iterable)entry.getValue()), ((VespaMetrics)entry.getKey()).description())).collect(Collectors.joining());
    }

    private static Map.Entry<String, String> withSuffix(String metricName) {
        try {
            int suffixIndex = metricName.lastIndexOf(".");
            Suffix suffix = Suffix.valueOf(metricName.substring(suffixIndex + 1));
            return Map.entry(metricName.substring(0, suffixIndex), suffix.toString());
        }
        catch (Exception e) {
            return Map.entry(metricName, "N/A");
        }
    }
}

