/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.set.Metric;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MetricSet {
    private final String id;
    private final Map<String, Metric> metrics;
    private final Set<MetricSet> children;

    public MetricSet(String id, Collection<Metric> metrics) {
        this(id, metrics, Set.of());
    }

    public MetricSet(String id, Collection<Metric> metrics, Collection<MetricSet> children) {
        this.id = Objects.requireNonNull(id, "Id cannot be null or empty.");
        this.metrics = this.toMapByName(metrics);
        this.children = new LinkedHashSet<MetricSet>(children);
    }

    public static MetricSet empty() {
        return new MetricSet("empty", Set.of());
    }

    public final String getId() {
        return this.id;
    }

    public final Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.flatten(this.metrics, this.children));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricSet)) {
            return false;
        }
        MetricSet that = (MetricSet)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    private Map<String, Metric> flatten(Map<String, Metric> metrics, Set<MetricSet> children) {
        LinkedHashMap<String, Metric> joinedMetrics = new LinkedHashMap<String, Metric>(metrics);
        for (MetricSet child : children) {
            child.getMetrics().forEach((name, metric) -> {
                if (joinedMetrics.containsKey(name)) {
                    joinedMetrics.put((String)name, ((Metric)joinedMetrics.get(name)).addDimensionsFrom((Metric)metric));
                } else {
                    joinedMetrics.put((String)name, (Metric)metric);
                }
            });
        }
        return joinedMetrics;
    }

    private Map<String, Metric> toMapByName(Collection<Metric> metrics) {
        LinkedHashMap<String, Metric> metricMap = new LinkedHashMap<String, Metric>();
        metrics.forEach(metric -> metricMap.put(metric.name, (Metric)metric));
        return metricMap;
    }

    public static class Builder {
        private final String id;
        private final Set<Metric> metrics = new LinkedHashSet<Metric>();
        private final Set<MetricSet> children = new LinkedHashSet<MetricSet>();

        public Builder(String id) {
            this.id = id;
        }

        public Builder metric(String metric) {
            return this.metric(new Metric(metric));
        }

        public Builder metric(VespaMetrics metric, EnumSet<Suffix> suffixes) {
            suffixes.forEach(suffix -> this.metrics.add(new Metric(metric.baseName() + "." + suffix.suffix())));
            return this;
        }

        public Builder metric(Metric metric) {
            this.metrics.add(metric);
            return this;
        }

        public Builder metrics(Collection<Metric> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        public Builder metricSet(MetricSet child) {
            this.children.add(child);
            return this;
        }

        public MetricSet build() {
            return new MetricSet(this.id, this.metrics, this.children);
        }
    }
}

