/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Metric {
    private final Instant time;
    private final Number value;
    private final String description;
    private MetricId name;
    private Map<DimensionId, String> dimensions;
    private Set<ConsumerId> consumers;

    public Metric(MetricId name, Number value, Instant time, Map<DimensionId, String> dimensions, String description) {
        this.time = time;
        this.value = value;
        this.name = name;
        this.dimensions = Map.copyOf(dimensions);
        this.description = description;
    }

    public Metric(MetricId name, Number value, long timestamp) {
        this(name, value, Instant.ofEpochSecond(timestamp), Map.of(), "");
    }

    public Metric(MetricId name, Number value, Instant timestamp) {
        this(name, value, timestamp, Map.of(), "");
    }

    public Metric(MetricId name, Number value) {
        this(name, value, Instant.now());
    }

    public void setDimensions(Map<DimensionId, String> dimensions) {
        this.dimensions = Map.copyOf(dimensions);
    }

    public Map<DimensionId, String> getDimensions() {
        return this.dimensions;
    }

    public void setConsumers(Set<ConsumerId> consumers) {
        this.consumers = consumers;
    }

    public Set<ConsumerId> getConsumers() {
        return this.consumers;
    }

    public Number getValue() {
        return this.value;
    }

    public void setName(MetricId name) {
        this.name = name;
    }

    public MetricId getName() {
        return this.name;
    }

    public Instant getTimeStamp() {
        return this.time;
    }

    public String toString() {
        return "Metric{time=" + String.valueOf(this.time) + ", name=" + this.name.id + ", value='" + String.valueOf(this.value) + "', dimensions=" + String.valueOf(this.dimensions) + "}";
    }

    public Metric clone() {
        return new Metric(this.name, this.value, this.time, this.dimensions, this.getDescription());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric rhs = (Metric)obj;
        return this.name.equals(rhs.name) && this.description.equals(rhs.description) && this.value.equals(rhs.value) && this.time.equals(rhs.time) && Objects.equals(this.dimensions, rhs.dimensions) && Objects.equals(this.consumers, rhs.consumers);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.value, this.dimensions, this.consumers, this.time);
    }

    public String getDescription() {
        return this.description;
    }

    public static long adjustTime(long timestamp, long now) {
        if (now == timestamp + 1L && now % 60L == 0L) {
            return now;
        }
        return timestamp;
    }
}

