/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.metric.model.Dimension;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConfiguredMetric {
    private final MetricId name;
    private final String description;
    private final MetricId outputname;
    private final List<Dimension> dimension;

    public ConfiguredMetric(ConsumersConfig.Consumer.Metric m) {
        this.name = MetricId.toMetricId(m.name());
        this.outputname = MetricId.toMetricId(m.outputname());
        this.description = m.description();
        this.dimension = new ArrayList<Dimension>(m.dimension().size());
        m.dimension().forEach(d -> this.dimension.add(new Dimension(DimensionId.toDimensionId(d.key()), d.value())));
    }

    public MetricId id() {
        return this.name;
    }

    public MetricId outputname() {
        return this.outputname;
    }

    public String description() {
        return this.description;
    }

    public List<Dimension> dimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredMetric that = (ConfiguredMetric)o;
        return this.name.equals(that.name) && this.description.equals(that.description) && this.outputname.equals(that.outputname) && this.dimension.equals(that.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.outputname, this.dimension);
    }
}

