/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model;

import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusUtil;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import java.util.Map;
import java.util.Objects;

public final class DimensionId {
    private static final Map<String, DimensionId> dictionary = new CopyOnWriteHashMap();
    public final String id;
    private final String idForPrometheus;

    private DimensionId(String id) {
        this.id = id;
        this.idForPrometheus = PrometheusUtil.sanitize(id);
    }

    public static DimensionId toDimensionId(String id) {
        return dictionary.computeIfAbsent(id, key -> new DimensionId((String)key));
    }

    public String getIdForPrometheus() {
        return this.idForPrometheus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionId that = (DimensionId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

