/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ErrorDirective;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.HopDirective;
import com.yahoo.messagebus.routing.PolicyDirective;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RouteDirective;
import com.yahoo.messagebus.routing.TcpDirective;
import com.yahoo.messagebus.routing.VerbatimDirective;

public class RouteParser {
    private final String routeText;

    RouteParser(String route) {
        this.routeText = route;
    }

    Route route() {
        Route route = new Route();
        int from = 0;
        int depth = 0;
        for (int at = 0; at <= this.routeText.length(); ++at) {
            if (at == this.routeText.length() || depth == 0 && Character.isWhitespace(this.routeText.charAt(at))) {
                if (from < at) {
                    Hop hop = RouteParser.createHop(this.routeText.substring(from, at));
                    if (hop.hasDirectives() && hop.getDirective(0) instanceof ErrorDirective) {
                        return new Route().addHop(new Hop().addDirective(hop.getDirective(0)));
                    }
                    route.addHop(hop);
                }
                from = at + 1;
                continue;
            }
            if (this.routeText.charAt(at) == '(' || this.routeText.charAt(at) == '[') {
                ++depth;
                continue;
            }
            if (this.routeText.charAt(at) != ')' && this.routeText.charAt(at) != ']') continue;
            --depth;
        }
        return route;
    }

    private static Hop createHop(String s) {
        int len = s.length();
        if (len == 0) {
            return new Hop().addDirective(RouteParser.createErrorDirective("Failed to parse empty string."));
        }
        if (len > 1 && s.charAt(0) == '?') {
            return RouteParser.createHop(s.substring(1, len)).setIgnoreResult(true);
        }
        if (len > 4 && s.charAt(0) == 't' && s.charAt(1) == 'c' && s.charAt(2) == 'p' && s.charAt(3) == '/') {
            HopDirective directive = RouteParser.createTcpDirective(s.substring(4, len));
            if (directive != null) {
                return new Hop().addDirective(directive);
            }
        } else if (len > 6 && s.charAt(0) == 'r' && s.charAt(1) == 'o' && s.charAt(2) == 'u' && s.charAt(3) == 't' && s.charAt(4) == 'e' && s.charAt(5) == ':') {
            return new Hop().addDirective(RouteParser.createRouteDirective(s.substring(6, len)));
        }
        Hop hop = new Hop();
        int from = 0;
        int depth = 0;
        for (int at = 0; at <= len; ++at) {
            if (at == len) {
                if (depth > 0) {
                    return new Hop().addDirective(RouteParser.createErrorDirective("Unterminated '[' in '" + s + "'"));
                }
                hop.addDirective(RouteParser.createDirective(s.substring(from, at)));
                from = at + 1;
                continue;
            }
            char c = s.charAt(at);
            if (Character.isWhitespace(c) && depth == 0) {
                return new Hop().addDirective(RouteParser.createErrorDirective("Failed to completely parse '" + s + "'."));
            }
            if (depth == 0 && c == '/') {
                hop.addDirective(RouteParser.createDirective(s.substring(from, at)));
                from = at + 1;
                continue;
            }
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c != ']') continue;
            if (depth == 0) {
                return new Hop().addDirective(RouteParser.createErrorDirective("Unexpected token ']' in '" + s + "'"));
            }
            --depth;
        }
        return hop;
    }

    private static HopDirective createErrorDirective(String s) {
        return new ErrorDirective(s);
    }

    private static HopDirective createTcpDirective(String s) {
        int posP = s.indexOf(58);
        if (posP <= 0) {
            return null;
        }
        int posS = s.indexOf(47, posP + 1);
        if (posS <= posP + 1) {
            return null;
        }
        return new TcpDirective(s.substring(0, posP), Integer.valueOf(s.substring(posP + 1, posS)), s.substring(posS + 1));
    }

    private static HopDirective createRouteDirective(String s) {
        return new RouteDirective(s);
    }

    private static HopDirective createDirective(String s) {
        return s.length() > 2 && s.charAt(0) == '[' ? (s.charAt(s.length() - 1) == ']' ? RouteParser.createPolicyDirective(s.substring(1, s.length() - 1)) : RouteParser.createErrorDirective("Unterminated '[' in '" + s + "'")) : RouteParser.createVerbatimDirective(s);
    }

    private static HopDirective createPolicyDirective(String s) {
        int pos = s.indexOf(58);
        return pos == -1 ? new PolicyDirective(s, "") : new PolicyDirective(s.substring(0, pos), s.substring(pos + 1).trim());
    }

    private static HopDirective createVerbatimDirective(String s) {
        return new VerbatimDirective(s);
    }
}

