/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.RetryPolicy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class RetryTransientErrorsPolicy
implements RetryPolicy {
    private static final double US = 1000000.0;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private volatile AtomicLong baseDelayUS = new AtomicLong(1000L);

    public RetryTransientErrorsPolicy setEnabled(boolean enabled) {
        this.enabled.set(enabled);
        return this;
    }

    public RetryTransientErrorsPolicy setBaseDelay(double baseDelay) {
        this.baseDelayUS.set((long)(baseDelay * 1000000.0));
        return this;
    }

    @Override
    public boolean canRetry(int errorCode) {
        return this.enabled.get() && errorCode < 200000;
    }

    @Override
    public double getRetryDelay(int retry) {
        long retryMultiplier = 0L;
        if (retry > 1) {
            retryMultiplier = 1L << Math.min(20, retry - 1);
        }
        return Math.min(10.0, (double)(retryMultiplier * this.baseDelayUS.get()) / 1000000.0);
    }
}

