/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.process.SpecialTokens;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SpecialTokenRegistry {
    private final Map<String, SpecialTokens> specialTokenMap;

    public SpecialTokenRegistry() {
        this(List.of());
    }

    public SpecialTokenRegistry(SpecialtokensConfig config) {
        this(SpecialTokenRegistry.specialTokensFrom(config));
    }

    public SpecialTokenRegistry(List<SpecialTokens> specialTokensList) {
        this.specialTokenMap = specialTokensList.stream().collect(Collectors.toUnmodifiableMap(t -> t.name(), t -> t));
    }

    private static List<SpecialTokens> specialTokensFrom(SpecialtokensConfig config) {
        ArrayList<SpecialTokens> specialTokensList = new ArrayList<SpecialTokens>();
        for (SpecialtokensConfig.Tokenlist tokenListConfig : config.tokenlist()) {
            ArrayList<SpecialTokens.Token> tokenList = new ArrayList<SpecialTokens.Token>();
            for (SpecialtokensConfig.Tokenlist.Tokens tokenConfig : tokenListConfig.tokens()) {
                tokenList.add(new SpecialTokens.Token(tokenConfig.token(), tokenConfig.replace()));
            }
            specialTokensList.add(new SpecialTokens(tokenListConfig.name(), tokenList));
        }
        return specialTokensList;
    }

    public SpecialTokens getSpecialTokens(String name) {
        if (name == null || name.trim().equals("")) {
            name = "default";
        }
        return this.specialTokenMap.getOrDefault(name, SpecialTokens.empty());
    }
}

