/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

public enum TokenType {
    UNKNOWN(0),
    SPACE(1),
    PUNCTUATION(2),
    SYMBOL(3),
    ALPHABETIC(4),
    NUMERIC(5),
    INDEXABLE_SYMBOL(6),
    MARKER(255);

    private final int value;

    private TokenType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isIndexable() {
        return switch (this) {
            case ALPHABETIC, NUMERIC, INDEXABLE_SYMBOL -> true;
            default -> false;
        };
    }

    public static TokenType valueOf(int value) {
        for (TokenType type : TokenType.values()) {
            if (value != type.value) continue;
            return type;
        }
        return UNKNOWN;
    }
}

