/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.simple;

import com.yahoo.component.annotation.Inject;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detector;
import com.yahoo.language.process.CharacterClasses;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.language.process.Normalizer;
import com.yahoo.language.process.Segmenter;
import com.yahoo.language.process.SegmenterImpl;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.process.Stemmer;
import com.yahoo.language.process.StemmerImpl;
import com.yahoo.language.process.Tokenizer;
import com.yahoo.language.process.Transformer;
import com.yahoo.language.simple.SimpleDetector;
import com.yahoo.language.simple.SimpleNormalizer;
import com.yahoo.language.simple.SimpleTokenizer;
import com.yahoo.language.simple.SimpleTransformer;
import java.util.List;

public class SimpleLinguistics
implements Linguistics {
    private final Normalizer normalizer;
    private final Transformer transformer;
    private final Detector detector;
    private final CharacterClasses characterClasses;
    private final GramSplitter gramSplitter;
    private final SpecialTokenRegistry specialTokenRegistry = new SpecialTokenRegistry(List.of());

    @Inject
    public SimpleLinguistics() {
        this.normalizer = new SimpleNormalizer();
        this.transformer = new SimpleTransformer();
        this.detector = new SimpleDetector();
        this.characterClasses = new CharacterClasses();
        this.gramSplitter = new GramSplitter(this.characterClasses);
    }

    @Override
    public Stemmer getStemmer() {
        return new StemmerImpl(this.getTokenizer());
    }

    @Override
    public Tokenizer getTokenizer() {
        return new SimpleTokenizer(this.normalizer, this.transformer, this.specialTokenRegistry);
    }

    @Override
    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public Segmenter getSegmenter() {
        return new SegmenterImpl(this.getTokenizer());
    }

    @Override
    public Detector getDetector() {
        return this.detector;
    }

    @Override
    public GramSplitter getGramSplitter() {
        return this.gramSplitter;
    }

    @Override
    public CharacterClasses getCharacterClasses() {
        return this.characterClasses;
    }

    @Override
    public boolean equals(Linguistics other) {
        return other instanceof SimpleLinguistics;
    }
}

