/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.process.CharacterClasses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class GramSplitter {
    private final CharacterClasses characterClasses;

    public GramSplitter(CharacterClasses characterClasses) {
        this.characterClasses = characterClasses;
    }

    public GramSplitterIterator split(String input, int n) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("n (gram size) cannot be smaller than 1, was " + n);
        }
        return new GramSplitterIterator(input, n, this.characterClasses);
    }

    public static class GramSplitterIterator
    implements Iterator<Gram> {
        private final CharacterClasses characterClasses;
        private final UnicodeString input;
        private final int n;
        private int i = 0;
        private boolean isFirstAfterSeparator = true;
        private Gram nextGram = null;

        public GramSplitterIterator(String input, int n, CharacterClasses characterClasses) {
            this.input = new UnicodeString(input);
            this.n = n;
            this.characterClasses = characterClasses;
        }

        @Override
        public boolean hasNext() {
            if (this.nextGram != null) {
                return true;
            }
            this.nextGram = this.findNext();
            return this.nextGram != null;
        }

        @Override
        public Gram next() {
            Gram currentGram = this.nextGram;
            if (currentGram == null) {
                currentGram = this.findNext();
            }
            if (currentGram == null) {
                throw new NoSuchElementException("No next gram at position " + this.i);
            }
            this.nextGram = null;
            return currentGram;
        }

        private Gram findNext() {
            while (this.i < this.input.length() && !this.isIndexable(this.input.codePointAt(this.i))) {
                this.i = this.input.next(this.i);
                this.isFirstAfterSeparator = true;
            }
            if (this.i >= this.input.length()) {
                return null;
            }
            int tokenStart = this.i;
            UnicodeString gram = this.input.substring(tokenStart, this.n);
            int tokenEnd = this.tokenEnd(gram);
            if ((gram = new UnicodeString(gram.toString().substring(0, tokenEnd))).codePointCount() == this.n) {
                Gram g = new Gram(this.i, gram.codePointCount());
                this.i = this.input.next(this.i);
                this.isFirstAfterSeparator = false;
                return g;
            }
            if (this.isFirstAfterSeparator || gram.codePointCount() == 1 && this.characterClasses.isSymbol(gram.codePointAt(0))) {
                Gram g = new Gram(this.i, gram.codePointCount());
                this.i = this.input.next(this.i);
                this.isFirstAfterSeparator = false;
                return g;
            }
            this.i = this.input.skip(gram.codePointCount(), this.i);
            this.isFirstAfterSeparator = true;
            return this.findNext();
        }

        private boolean isIndexable(int codepoint) {
            if (this.characterClasses.isLetterOrDigit(codepoint)) {
                return true;
            }
            return this.characterClasses.isSymbol(codepoint);
        }

        private int tokenEnd(UnicodeString s) {
            if (this.characterClasses.isSymbol(s.codePointAt(0))) {
                return s.next(0);
            }
            int i = 0;
            while (i < s.length()) {
                if (!this.characterClasses.isLetterOrDigit(s.codePointAt(i))) {
                    return i;
                }
                i = s.next(i);
            }
            return i;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is read only");
        }

        public List<String> toExtractedList() {
            ArrayList<String> gramList = new ArrayList<String>();
            while (this.hasNext()) {
                gramList.add(this.next().extractFrom(this.input));
            }
            return Collections.unmodifiableList(gramList);
        }
    }

    private static class UnicodeString {
        private final String s;

        public UnicodeString(String s) {
            this.s = s;
        }

        public UnicodeString substring(int start, int codePoints) {
            int cps = codePoints * 2 <= this.s.length() - start ? codePoints : Math.min(codePoints, this.s.codePointCount(start, this.s.length()));
            return new UnicodeString(this.s.substring(start, this.s.offsetByCodePoints(start, cps)));
        }

        public int skip(int codePointCount, int start) {
            int index = start;
            for (int i = 0; i < codePointCount && (index = this.next(index)) <= this.s.length(); ++i) {
            }
            return index;
        }

        public int next(int index) {
            int next = index + 1;
            if (next < this.s.length() && Character.isLowSurrogate(this.s.charAt(next))) {
                ++next;
            }
            return next;
        }

        public int length() {
            return this.s.length();
        }

        public int codePointCount() {
            return this.s.codePointCount(0, this.s.length());
        }

        public int codePointAt(int index) {
            return this.s.codePointAt(index);
        }

        public String toString() {
            return this.s;
        }
    }

    public static final class Gram {
        private final int start;
        private final int codePointCount;

        public Gram(int start, int codePointCount) {
            this.start = start;
            this.codePointCount = codePointCount;
        }

        public int getStart() {
            return this.start;
        }

        public int getCodePointCount() {
            return this.codePointCount;
        }

        public String extractFrom(String input) {
            return this.extractFrom(new UnicodeString(input));
        }

        public String extractFrom(UnicodeString input) {
            return input.substring(this.start, this.codePointCount).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Gram)) {
                return false;
            }
            Gram gram = (Gram)o;
            if (this.codePointCount != gram.codePointCount) {
                return false;
            }
            return this.start == gram.start;
        }

        public int hashCode() {
            int result = this.start;
            result = 31 * result + this.codePointCount;
            return result;
        }
    }
}

