/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.InvocationClient;
import com.yahoo.jrt.InvocationServer;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Values;

public class Request {
    private String methodName;
    private Values parameters;
    private Values returnValues = new Values();
    private int errorCode = 0;
    private String errorMessage = null;
    private boolean detached = false;
    private Object context = null;
    private InvocationServer serverHandler;
    private InvocationClient clientHandler;

    Request(String methodName, Values parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    void clientHandler(InvocationClient handler) {
        this.clientHandler = handler;
    }

    void serverHandler(InvocationServer handler) {
        this.serverHandler = handler;
    }

    public Request(String methodName) {
        this(methodName, new Values());
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public Object getContext() {
        return this.context;
    }

    public String methodName() {
        return this.methodName;
    }

    public Values parameters() {
        return this.parameters;
    }

    void returnValues(Values returnValues) {
        this.returnValues = returnValues;
    }

    public Values returnValues() {
        return this.returnValues;
    }

    public void discardParameters() {
        this.parameters = new Values();
    }

    public Target target() {
        if (this.serverHandler == null) {
            throw new IllegalStateException("No server handler registered");
        }
        return this.serverHandler.getTarget();
    }

    public void abort() {
        if (this.clientHandler == null) {
            throw new IllegalStateException("No client handler registered");
        }
        this.clientHandler.handleAbort();
    }

    public void detach() {
        if (this.serverHandler == null) {
            throw new IllegalStateException("No server handler registered");
        }
        this.detached = true;
    }

    boolean isDetached() {
        return this.detached;
    }

    public void returnRequest() {
        if (!this.detached) {
            throw new IllegalStateException("Request not detached");
        }
        this.serverHandler.returnRequest();
    }

    public void setError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public boolean checkReturnTypes(String returnTypes) {
        if (this.errorCode != 0) {
            return false;
        }
        if (this.returnValues.satisfies(returnTypes)) {
            return true;
        }
        this.setError(109, "checkReturnValues: Wrong return values");
        return false;
    }

    public boolean isError() {
        return this.errorCode != 0;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "request " + this.methodName + "(" + String.valueOf(this.parameters) + ")" + (String)(this.returnValues.size() > 0 ? ": " + String.valueOf(this.returnValues) : "");
    }
}

