/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Values {
    private List<Value> values = new ArrayList<Value>(16);

    public boolean satisfies(String types) {
        int off;
        int len = Math.min(types.length(), this.size());
        for (off = 0; off < len && types.charAt(off) == this.get(off).type(); ++off) {
        }
        return off == types.length() && off == this.size() || off + 1 == types.length() && types.charAt(off) == '*';
    }

    public Values() {
    }

    Values(ByteBuffer src) {
        this.decode(src);
    }

    public Values add(Value value) {
        this.values.add(value);
        return this;
    }

    public Value get(int idx) {
        return this.values.get(idx);
    }

    public int size() {
        return this.values.size();
    }

    int bytes() {
        int bytes = 4 + this.values.size();
        for (int i = 0; i < this.values.size(); ++i) {
            bytes += this.get(i).bytes();
        }
        return bytes;
    }

    void encode(ByteBuffer dst) {
        int i;
        byte[] types = new byte[this.values.size()];
        for (i = 0; i < types.length; ++i) {
            types[i] = this.get(i).type();
        }
        dst.putInt(types.length);
        dst.put(types);
        for (i = 0; i < types.length; ++i) {
            this.get(i).encode(dst);
        }
    }

    void decode(ByteBuffer src) {
        this.values.clear();
        int cnt = src.getInt();
        byte[] types = new byte[cnt];
        src.get(types);
        for (int i = 0; i < cnt; ++i) {
            this.values.add(Value.decode(types[i], src));
        }
    }

    public String toString() {
        if (this.values.size() == 0) {
            return "";
        }
        if (this.values.size() == 1) {
            return this.values.get(0).toString();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.values.size(); ++i) {
            buffer.append(this.values.get(i).toString());
            if (i >= this.values.size() - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }
}

