/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import java.nio.ByteBuffer;

class Buffer {
    private ByteBuffer buf;
    private int readPos;
    private int writePos;
    private boolean readMode;

    private void setReadMode() {
        if (this.readMode) {
            this.buf.limit(this.writePos);
            return;
        }
        this.writePos = this.buf.position();
        this.buf.position(this.readPos);
        this.buf.limit(this.writePos);
        this.readMode = true;
    }

    private void setWriteMode() {
        if (!this.readMode) {
            this.buf.limit(this.buf.capacity());
            return;
        }
        this.readPos = this.buf.position();
        this.buf.limit(this.buf.capacity());
        if (this.readPos == this.writePos) {
            this.readPos = 0;
            this.writePos = 0;
        }
        this.buf.position(this.writePos);
        this.readMode = false;
    }

    private void ensureFree(int minFree) {
        if (this.buf.remaining() >= minFree) {
            return;
        }
        this.writePos = this.buf.position();
        int used = this.writePos - this.readPos;
        int free = this.buf.remaining() + this.readPos;
        if (free >= minFree && free >= used) {
            this.buf.position(this.readPos);
            this.buf.limit(this.writePos);
            this.buf.compact();
            this.readPos = 0;
        } else {
            int size = this.buf.capacity() * 2;
            if (this.buf.capacity() + free < minFree) {
                size = this.buf.capacity() + minFree;
            }
            ByteBuffer tmp = ByteBuffer.allocate(size);
            tmp.order(this.buf.order());
            this.buf.position(this.readPos);
            this.buf.limit(this.writePos);
            tmp.put(this.buf);
            this.buf = tmp;
            this.readPos = 0;
        }
    }

    public Buffer(int size) {
        this.buf = ByteBuffer.allocate(size);
        this.readPos = 0;
        this.writePos = 0;
        this.readMode = false;
    }

    public boolean shrink(int size) {
        int rpos;
        int wpos = this.readMode ? this.writePos : this.buf.position();
        int used = wpos - (rpos = this.readMode ? this.buf.position() : this.readPos);
        if (used > size || this.buf.capacity() <= size) {
            return false;
        }
        ByteBuffer tmp = ByteBuffer.allocate(size);
        tmp.order(this.buf.order());
        this.buf.position(rpos);
        this.buf.limit(wpos);
        tmp.put(this.buf);
        this.buf = tmp;
        this.readPos = 0;
        this.writePos = used;
        this.buf.position(this.readMode ? this.readPos : this.writePos);
        this.buf.limit(this.readMode ? this.writePos : this.buf.capacity());
        return true;
    }

    public int bytes() {
        return this.readMode ? this.writePos - this.buf.position() : this.buf.position() - this.readPos;
    }

    public ByteBuffer getReadable() {
        this.setReadMode();
        return this.buf;
    }

    public ByteBuffer getWritable(int minFree) {
        this.setWriteMode();
        this.ensureFree(minFree);
        return this.buf;
    }
}

