/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class StringArray
extends Value {
    private byte[][] value;

    public StringArray(String[] value) {
        this.value = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            try {
                this.value[i] = value[i].getBytes("UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    StringArray(ByteBuffer src) {
        int size = src.getInt();
        this.value = new byte[size][];
        for (int i = 0; i < size; ++i) {
            this.value[i] = new byte[src.getInt()];
            src.get(this.value[i]);
        }
    }

    @Override
    public byte type() {
        return 83;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        int bytes = 4;
        for (int i = 0; i < this.value.length; ++i) {
            bytes += 4 + this.value[i].length;
        }
        return bytes;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            dst.putInt(this.value[i].length);
            dst.put(this.value[i]);
        }
    }

    @Override
    public String[] asStringArray() {
        String[] ret = new String[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            try {
                ret[i] = new String(this.value[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.asStringArray());
    }
}

