/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.annotation.internal.SimpleIndexingAnnotations;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.TokenType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import java.util.Objects;

public final class ExactExpression
extends Expression {
    private final AnnotatorConfig config;

    public ExactExpression(AnnotatorConfig config) {
        this.config = config;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        return super.setInputType(inputType, (DataType)DataType.STRING, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        return super.setOutputType((DataType)DataType.STRING, outputType, null, context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        SpanList root;
        String next;
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        if (input.getString().isEmpty()) {
            return;
        }
        StringFieldValue output = input.clone();
        context.setCurrentValue((FieldValue)output);
        String prev = output.getString();
        String string = next = this.config.getLowercase() ? LinguisticsCase.toLowerCase((String)prev) : prev;
        if (next.length() > this.config.getMaxTokenLength()) {
            output.removeSpanTree("linguistics");
            return;
        }
        if (output.wantSimpleAnnotations()) {
            SimpleIndexingAnnotations simple = new SimpleIndexingAnnotations();
            String termOverride = next.equals(prev) ? null : next;
            simple.add(0, prev.length(), termOverride);
            output.setSimpleAnnotations(simple);
            return;
        }
        SpanTree tree = output.getSpanTree("linguistics");
        if (tree == null) {
            root = new SpanList();
            tree = new SpanTree("linguistics", (SpanNode)root);
            output.setSpanTree(tree);
        } else {
            root = (SpanList)tree.getRoot();
        }
        Span node = new Span(0, prev.length());
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TERM, (FieldValue)(next.equals(prev) ? null : new StringFieldValue(next))));
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TOKEN_TYPE, (FieldValue)new IntegerFieldValue(TokenType.ALPHABETIC.getValue())));
        root.add((SpanNode)node);
    }

    public String toString() {
        return "exact" + this.config.parameterString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExactExpression)) {
            return false;
        }
        ExactExpression other = (ExactExpression)((Object)o);
        return this.config.equals(other.config);
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.config);
    }
}

