/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fsa.topicpredictor;

import com.yahoo.fsa.FSA;
import com.yahoo.fsa.MetaData;
import com.yahoo.fsa.topicpredictor.PredictedTopic;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public final class TopicPredictor
extends MetaData {
    private static final String packageName = "com.yahoo.fsa.topicpredictor";
    private final FSA fsa;

    public TopicPredictor(String fsafile, String datfile) {
        this(fsafile, datfile, "utf-8");
    }

    public TopicPredictor(String fsafile, String datfile, String charsetname) {
        super(datfile, charsetname);
        if (!this.isOk()) {
            Logger.getLogger(packageName).warning("Error initializing predictor with file " + datfile);
        }
        this.fsa = new FSA(fsafile);
        if (!this.fsa.isOk()) {
            Logger.getLogger(packageName).warning("Error initializing FSA with file " + fsafile);
        }
    }

    public List<PredictedTopic> getPredictedTopics(String segment) {
        return this.getPredictedTopics(segment, 0);
    }

    public List<PredictedTopic> getPredictedTopics(String segment, int maxTopics) {
        int[][] topicArr;
        LinkedList<PredictedTopic> predictedTopics = new LinkedList<PredictedTopic>();
        int segIdx = this.getSegmentIndex(segment);
        for (int[] ints : topicArr = this.getTopicArray(segIdx, maxTopics)) {
            int weight = ints[1];
            String[] topicInfo = this.getTopicInfo(ints[0]);
            String topic = topicInfo[0];
            String vector = topicInfo[1];
            PredictedTopic pt = new PredictedTopic(topic, weight, vector);
            predictedTopics.add(pt);
        }
        return predictedTopics;
    }

    private int getSegmentIndex(String segment) {
        FSA.State s = this.fsa.getState();
        s.delta(segment);
        if (s.isFinal()) {
            return s.hash();
        }
        return -1;
    }

    private int getNumTopics(int segIdx) {
        if (segIdx < 0) {
            return 0;
        }
        ByteBuffer buf = this.getIndirectRecordEntry(segIdx, 4);
        return buf.getInt(0);
    }

    private int[][] getTopicArray(int segIdx, int maxTopics) {
        if (segIdx < 0) {
            return new int[0][0];
        }
        int numTopics = this.getNumTopics(segIdx);
        if (maxTopics > 0 && numTopics > maxTopics) {
            numTopics = maxTopics;
        }
        int[][] topics = new int[numTopics][2];
        ByteBuffer buf = this.getIndirectRecordEntry(segIdx, 4 + 8 * numTopics);
        for (int i = 0; i < numTopics; ++i) {
            topics[i][0] = buf.getInt(4 + 8 * i);
            topics[i][1] = buf.getInt(8 + 8 * i);
        }
        return topics;
    }

    private String[] getTopicInfo(int topicId) {
        return this.getStringArrayEntry(this.user(0) + topicId, 2);
    }
}

