/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.documentapi.messagebus.protocol.DocumentListEntry;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.VisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.VisitorReply;
import java.util.ArrayList;
import java.util.List;

public class DocumentListMessage
extends VisitorMessage {
    private BucketId bucket = new BucketId(16, 0L);
    private final List<DocumentListEntry> entries = new ArrayList<DocumentListEntry>();

    public DocumentListMessage() {
    }

    public DocumentListMessage(DocumentListMessage cmd) {
        this.bucket = cmd.bucket;
        this.entries.addAll(cmd.entries);
    }

    public BucketId getBucketId() {
        return this.bucket;
    }

    public void setBucketId(BucketId id) {
        this.bucket = id;
    }

    public List<DocumentListEntry> getDocuments() {
        return this.entries;
    }

    @Override
    public DocumentReply createReply() {
        return new VisitorReply(200021);
    }

    public int getType() {
        return 100021;
    }

    @Override
    public int getApproxSize() {
        return DocumentListEntry.getApproxSize() * this.entries.size();
    }

    public String toString() {
        return "DocumentListMessage(" + this.entries.toString() + ")";
    }
}

