/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.DocumentAccess;
import com.yahoo.documentapi.DocumentAccessException;
import com.yahoo.documentapi.SubscriptionParameters;
import com.yahoo.documentapi.SubscriptionSession;
import com.yahoo.documentapi.SyncParameters;
import com.yahoo.documentapi.VisitorDestinationParameters;
import com.yahoo.documentapi.VisitorParameters;
import com.yahoo.documentapi.messagebus.MessageBusAsyncSession;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.MessageBusSyncSession;
import com.yahoo.documentapi.messagebus.MessageBusVisitorDestinationSession;
import com.yahoo.documentapi.messagebus.MessageBusVisitorSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.NetworkMessageBus;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.RPCMessageBus;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.local.LocalNetwork;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MessageBusDocumentAccess
extends DocumentAccess {
    private static final Logger log = Logger.getLogger(MessageBusDocumentAccess.class.getName());
    private final NetworkMessageBus bus;
    private final MessageBusParams params;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), ThreadFactoryFactory.getDaemonThreadFactory((String)"mbus.access.scheduler"));

    public MessageBusDocumentAccess() {
        this(new MessageBusParams());
    }

    public MessageBusDocumentAccess(MessageBusParams params) {
        super(params);
        this.params = params;
        try {
            com.yahoo.messagebus.MessageBusParams mbusParams = new com.yahoo.messagebus.MessageBusParams(params.getMessageBusParams());
            mbusParams.addProtocol((Protocol)new DocumentProtocol(this.getDocumentTypeManager(), params.getProtocolConfigId()));
            if (System.getProperty("vespa.local", "false").equals("true")) {
                LocalNetwork network = new LocalNetwork();
                this.bus = new NetworkMessageBus((Network)network, new MessageBus((Network)network, mbusParams));
            } else if (mbusParams.getMessageBusConfig() != null) {
                this.bus = new RPCMessageBus(mbusParams, params.getRPCNetworkParams());
            } else {
                log.log(Level.FINE, () -> "Setting up self-subscription to config because explicit config was missing; try to avoid this in containers");
                this.bus = new RPCMessageBus(mbusParams, params.getRPCNetworkParams(), params.getRoutingConfigId());
            }
        }
        catch (Exception e) {
            throw new DocumentAccessException(e);
        }
    }

    private MessageBus messageBus() {
        return this.bus.getMessageBus();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.bus.destroy();
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public MessageBusSyncSession createSyncSession(SyncParameters parameters) {
        return new MessageBusSyncSession(parameters, this.messageBus(), this.params);
    }

    @Override
    public MessageBusAsyncSession createAsyncSession(AsyncParameters parameters) {
        return new MessageBusAsyncSession(parameters, this.messageBus(), this.params);
    }

    @Override
    public MessageBusVisitorSession createVisitorSession(VisitorParameters params) throws ParseException, IllegalArgumentException {
        MessageBusVisitorSession session = MessageBusVisitorSession.createForMessageBus(this.messageBus(), this.scheduledExecutorService, params);
        session.start();
        return session;
    }

    @Override
    public MessageBusVisitorDestinationSession createVisitorDestinationSession(VisitorDestinationParameters params) {
        return new MessageBusVisitorDestinationSession(params, this.bus.getMessageBus());
    }

    @Override
    public SubscriptionSession createSubscription(SubscriptionParameters parameters) {
        throw new UnsupportedOperationException("Subscriptions not supported.");
    }

    @Override
    public SubscriptionSession openSubscription(SubscriptionParameters parameters) {
        throw new UnsupportedOperationException("Subscriptions not supported.");
    }

    public MessageBus getMessageBus() {
        return this.messageBus();
    }

    public Network getNetwork() {
        return this.bus.getNetwork();
    }

    public MessageBusParams getParams() {
        return this.params;
    }
}

