/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public final class IntegerFieldValue
extends NumericFieldValue {
    public static final int classId = IntegerFieldValue.registerClass((int)4107, IntegerFieldValue.class);
    private int value;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public IntegerFieldValue() {
        this(0);
    }

    public IntegerFieldValue(int value) {
        this.value = value;
    }

    public IntegerFieldValue(Integer value) {
        this.value = value;
    }

    public IntegerFieldValue(String s) {
        this.value = Integer.parseInt(s);
    }

    @Override
    public IntegerFieldValue clone() {
        IntegerFieldValue val = (IntegerFieldValue)super.clone();
        val.value = this.value;
        return val;
    }

    @Override
    public Number getNumber() {
        return this.value;
    }

    @Override
    public void clear() {
        this.value = 0;
    }

    @Override
    public void assign(Object obj) {
        if (!this.checkAssign(obj)) {
            return;
        }
        if (obj instanceof Number) {
            this.value = ((Number)obj).intValue();
        } else if (obj instanceof NumericFieldValue) {
            this.value = ((NumericFieldValue)obj).getNumber().intValue();
        } else if (obj instanceof String || obj instanceof StringFieldValue) {
            this.value = Integer.parseInt(obj.toString());
        } else {
            throw new IllegalArgumentException("Class " + String.valueOf(obj.getClass()) + " not applicable to an " + String.valueOf(this.getClass()) + " instance.");
        }
    }

    public int getInteger() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printIntegerXml(this, xml);
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerFieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegerFieldValue that = (IntegerFieldValue)o;
        return this.value == that.value;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public DataType getDataType() {
        return DataType.INT;
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        IntegerFieldValue otherValue = (IntegerFieldValue)fieldValue;
        if (this.value < otherValue.value) {
            return -1;
        }
        if (this.value > otherValue.value) {
            return 1;
        }
        return 0;
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new IntegerFieldValue();
        }

        @Override
        public FieldValue create(String value) {
            return new IntegerFieldValue(value);
        }
    }
}

