/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.MapDataType;
import com.yahoo.document.WeightedSetDataType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FieldPath
implements Iterable<FieldPathEntry> {
    private final List<FieldPathEntry> list;

    public FieldPath() {
        this.list = List.of();
    }

    public FieldPath(FieldPath path) {
        this(path.list);
    }

    public FieldPath(List<FieldPathEntry> path) {
        this.list = Collections.unmodifiableList(path);
    }

    public int size() {
        return this.list.size();
    }

    public FieldPathEntry get(int index) {
        return this.list.get(index);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<FieldPathEntry> iterator() {
        return this.list.iterator();
    }

    public List<FieldPathEntry> getList() {
        return this.list;
    }

    public boolean startsWith(FieldPath other) {
        if (other.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < other.size(); ++i) {
            if (other.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public DataType getResultingDataType() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size() - 1).getResultingDataType();
    }

    public static FieldPath newInstance(DataType fieldType, String fieldPath) {
        return fieldType.buildFieldPath(fieldPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPath that = (FieldPath)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        DataType prevType = null;
        for (FieldPathEntry entry : this) {
            FieldPathEntry.Type type = entry.getType();
            switch (type) {
                case STRUCT_FIELD: {
                    if (!out.isEmpty()) {
                        out.append(".");
                    }
                    Field field = entry.getFieldRef();
                    out.append(field.getName());
                    prevType = field.getDataType();
                    break;
                }
                case ARRAY_INDEX: {
                    out.append("[").append(entry.getLookupIndex()).append("]");
                    break;
                }
                case MAP_KEY: {
                    out.append("{").append(entry.getLookupKey()).append("}");
                    break;
                }
                case MAP_ALL_KEYS: {
                    out.append(".key");
                    break;
                }
                case MAP_ALL_VALUES: {
                    out.append(".value");
                    break;
                }
                case VARIABLE: {
                    if (prevType instanceof ArrayDataType) {
                        out.append("[$").append(entry.getVariableName()).append("]");
                        break;
                    }
                    if (prevType instanceof WeightedSetDataType || prevType instanceof MapDataType) {
                        out.append("{$").append(entry.getVariableName()).append("}");
                        break;
                    }
                    out.append("$").append(entry.getVariableName());
                }
            }
        }
        return out.toString();
    }
}

