/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.internal;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.datatypes.Struct;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class GeoPosType
extends StructDataType {
    private final boolean useV8json;
    private static final Field F_X = new Field("x", DataType.INT);
    private static final Field F_Y = new Field("y", DataType.INT);
    private static final DecimalFormat degreeFmt = new DecimalFormat("0.0#####", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public GeoPosType(int vespaVersion) {
        super("position");
        boolean bl = this.useV8json = vespaVersion == 8;
        assert (vespaVersion > 6);
        assert (vespaVersion < 9);
        this.addField(F_X);
        this.addField(F_Y);
    }

    public boolean renderJsonAsVespa8() {
        return this.useV8json;
    }

    public double getLatitude(Struct pos) {
        assert (pos.getDataType() == this);
        double ns = (double)PositionDataType.getYValue(pos).getInteger() * 1.0E-6;
        return ns;
    }

    public double getLongitude(Struct pos) {
        assert (pos.getDataType() == this);
        double ew = (double)PositionDataType.getXValue(pos).getInteger() * 1.0E-6;
        return ew;
    }

    static String fmtD(double degrees) {
        return degreeFmt.format(degrees);
    }

    public String fmtLatitude(Struct pos) {
        assert (pos.getDataType() == this);
        double ns = (double)PositionDataType.getYValue(pos).getInteger() * 1.0E-6;
        return GeoPosType.fmtD(ns);
    }

    public String fmtLongitude(Struct pos) {
        assert (pos.getDataType() == this);
        double ew = (double)PositionDataType.getXValue(pos).getInteger() * 1.0E-6;
        return GeoPosType.fmtD(ew);
    }

    static {
        degreeFmt.setMinimumIntegerDigits(1);
        degreeFmt.setMinimumFractionDigits(1);
        degreeFmt.setMaximumFractionDigits(6);
    }
}

