/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.component.annotation.Inject;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationTypeRegistry;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentDeserializerFactory;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.TensorType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DocumentTypeManager {
    private Map<Integer, DataType> dataTypes = new LinkedHashMap<Integer, DataType>();
    private Map<DataTypeName, DocumentType> documentTypes = new LinkedHashMap<DataTypeName, DocumentType>();
    private AnnotationTypeRegistry annotationTypeRegistry = new AnnotationTypeRegistry();
    private boolean ignoreUndefinedFields = false;

    public DocumentTypeManager() {
        this.registerDefaultDataTypes();
    }

    @Inject
    public DocumentTypeManager(DocumentmanagerConfig config) {
        this();
        DocumentTypeManagerConfigurer.configureNewManager(config, this);
    }

    void internalAssign(DocumentTypeManager other) {
        this.dataTypes = other.dataTypes;
        this.documentTypes = other.documentTypes;
        this.annotationTypeRegistry = other.annotationTypeRegistry;
    }

    public static DocumentTypeManager fromFile(String fileName) {
        DocumentTypeManager manager = new DocumentTypeManager();
        ConfigSubscriber sub = DocumentTypeManagerConfigurer.configure(manager, "file:" + fileName);
        sub.close();
        return manager;
    }

    private void registerDefaultDataTypes() {
        DocumentType superDocType = DataType.DOCUMENT;
        this.dataTypes.put(superDocType.getId(), superDocType);
        this.documentTypes.put(superDocType.getDataTypeName(), superDocType);
        Class<DataType> dataTypeClass = DataType.class;
        for (Field field : dataTypeClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !DataType.class.isAssignableFrom(field.getType())) continue;
            try {
                DataType type = (DataType)field.get(null);
                this.register(type);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AnnotationType type : AnnotationTypes.ALL_TYPES) {
            this.annotationTypeRegistry.register(type);
        }
    }

    DataType getDataTypeInternal(String name) {
        if (name.startsWith("tensor(")) {
            return new TensorDataType(TensorType.fromSpec((String)name));
        }
        ArrayList<DataType> foundTypes = new ArrayList<DataType>();
        for (DataType type : this.dataTypes.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            foundTypes.add(type);
        }
        if (foundTypes.isEmpty()) {
            return null;
        }
        if (foundTypes.size() == 1) {
            return (DataType)foundTypes.get(0);
        }
        Collections.sort(foundTypes, new Comparator<DataType>(){

            @Override
            public int compare(DataType first, DataType second) {
                if (first instanceof StructuredDataType && !(second instanceof StructuredDataType)) {
                    return 1;
                }
                if (!(first instanceof StructuredDataType) && second instanceof StructuredDataType) {
                    return -1;
                }
                return 0;
            }
        });
        return (DataType)foundTypes.get(0);
    }

    public boolean getIgnoreUndefinedFields() {
        return this.ignoreUndefinedFields;
    }

    public void setIgnoreUndefinedFields(boolean ignoreUndefinedFields) {
        this.ignoreUndefinedFields = ignoreUndefinedFields;
    }

    DataType getDataTypeByCode(int code) {
        return this.getDataTypeByCode(code, "");
    }

    DataType getDataTypeByCode(int code, String detailedType) {
        if (code == 21) {
            return new TensorDataType(TensorType.fromSpec((String)detailedType));
        }
        DataType type = this.dataTypes.get(code);
        if (type == null) {
            StringBuilder types = new StringBuilder();
            for (Integer key : this.dataTypes.keySet()) {
                types.append(key).append(" ");
            }
            throw new IllegalArgumentException("No datatype with code " + code + ". Registered type ids: " + String.valueOf(types));
        }
        return type;
    }

    public void register(DataType type) {
        type.register(this);
    }

    void registerSingleType(DataType type) {
        if (type instanceof TensorDataType) {
            return;
        }
        if (this.dataTypes.containsKey(type.getId())) {
            DataType existingType = this.dataTypes.get(type.getId());
            if (existingType == type || existingType.equals(type)) {
                return;
            }
            throw new IllegalStateException("Datatype " + String.valueOf(existingType) + " is not equal to datatype attempted registered " + String.valueOf(type) + ", but already uses id " + type.getId());
        }
        if (type instanceof DocumentType) {
            DocumentType docType = (DocumentType)type;
            if (docType.getInheritedTypes().size() == 0) {
                docType.inherit(this.documentTypes.get(new DataTypeName("document")));
            }
            this.documentTypes.put(docType.getDataTypeName(), docType);
        }
        this.dataTypes.put(type.getId(), type);
        type.setRegistered();
    }

    public DocumentType registerDocumentType(DocumentType docType) {
        this.register(docType);
        return docType;
    }

    public DocumentType getDocumentType(DataTypeName name) {
        return this.documentTypes.get(name);
    }

    public DocumentType getDocumentType(String name) {
        return this.documentTypes.get(new DataTypeName(name));
    }

    public boolean hasDocumentType(String name) {
        return this.getDocumentType(name) != null;
    }

    public final Document createDocument(GrowableByteBuffer buf) {
        DocumentDeserializer data = DocumentDeserializerFactory.createHead(this, buf);
        return new Document(data);
    }

    public Document createDocument(DocumentDeserializer data) {
        return new Document(data);
    }

    public Collection<DataType> getDataTypes() {
        return Collections.unmodifiableCollection(this.dataTypes.values());
    }

    public Map<DataTypeName, DocumentType> getDocumentTypes() {
        return Collections.unmodifiableMap(this.documentTypes);
    }

    public Iterator<DocumentType> documentTypeIterator() {
        return this.documentTypes.values().iterator();
    }

    void internalClear() {
        this.documentTypes.clear();
        this.dataTypes.clear();
        this.registerDefaultDataTypes();
    }

    public AnnotationTypeRegistry getAnnotationTypeRegistry() {
        return this.annotationTypeRegistry;
    }
}

