/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.datatypes.FieldValue;
import java.util.TreeMap;

public abstract class FieldPathIteratorHandler {
    private VariableMap variables = new VariableMap();

    public void onPrimitive(FieldValue fv) {
    }

    public boolean onComplex(FieldValue fv) {
        return true;
    }

    public ModificationStatus doModify(FieldValue fv) {
        return ModificationStatus.NOT_MODIFIED;
    }

    public ModificationStatus modify(FieldValue fv) {
        return this.doModify(fv);
    }

    public boolean createMissingPath() {
        return false;
    }

    public VariableMap getVariables() {
        return this.variables;
    }

    public static class VariableMap
    extends TreeMap<String, IndexValue> {
        @Override
        public Object clone() {
            VariableMap map = new VariableMap();
            map.putAll(this);
            return map;
        }
    }

    public static enum ModificationStatus {
        MODIFIED,
        REMOVED,
        NOT_MODIFIED;

    }

    public static class IndexValue {
        private int index;
        private FieldValue key;

        public int getIndex() {
            return this.index;
        }

        public FieldValue getKey() {
            return this.key;
        }

        public IndexValue() {
            this.index = -1;
            this.key = null;
        }

        public IndexValue(int index) {
            this.index = index;
            this.key = null;
        }

        public IndexValue(FieldValue key) {
            this.index = -1;
            this.key = key;
        }

        public String toString() {
            if (this.key != null) {
                return this.key.toString();
            }
            return "" + this.index;
        }

        public int hashCode() {
            int hc = this.index;
            if (this.key != null) {
                hc = this.key.hashCode();
            }
            return hc;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexValue)) {
                return false;
            }
            IndexValue other = (IndexValue)o;
            if (this.key != null && other.key != null) {
                return this.key.equals(other.key);
            }
            if (this.key == null && other.key == null) {
                return this.index == other.index;
            }
            return false;
        }
    }
}

