/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;

public class RemoveValueUpdate
extends ValueUpdate {
    protected FieldValue value;

    public RemoveValueUpdate(FieldValue value) {
        super(ValueUpdate.ValueUpdateClassID.REMOVE);
        this.value = value;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public void setValue(FieldValue value) {
        this.value = value;
    }

    @Override
    public FieldValue applyTo(FieldValue fval) {
        if (fval instanceof CollectionFieldValue) {
            CollectionFieldValue val = (CollectionFieldValue)fval;
            val.removeValue(this.value);
        }
        return fval;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof CollectionDataType)) {
            throw new UnsupportedOperationException("Expected collection, got " + fieldType.getName() + ".");
        }
        fieldType = ((CollectionDataType)fieldType).getNestedType();
        if (this.value != null && !this.value.getDataType().equals(fieldType)) {
            throw new IllegalArgumentException("Expected " + fieldType.getName() + ", got " + this.value.getDataType().getName());
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this, superType);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof RemoveValueUpdate && super.equals(o) && this.value.equals(((RemoveValueUpdate)o).value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.value.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.value);
    }
}

