/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.json.TokenBuffer;
import java.io.IOException;
import java.util.function.Supplier;

public class LazyTokenBuffer
extends TokenBuffer {
    private final JsonParser parser;

    public LazyTokenBuffer(JsonParser parser) {
        this.parser = parser;
        try {
            this.addFromParser(parser);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed parsing document JSON", e);
        }
        if (JsonToken.START_OBJECT != this.current()) {
            throw new IllegalArgumentException("expected start of JSON object, but got " + String.valueOf(this.current()));
        }
        this.updateNesting(this.current());
    }

    @Override
    void advance() {
        super.advance();
        if (this.tokens.isEmpty() && this.nesting() > 0) {
            this.tokens.add(this.nextToken());
        }
    }

    @Override
    public Supplier<TokenBuffer.Token> lookahead() {
        return new Supplier<TokenBuffer.Token>(){
            int localNesting;
            final Supplier<TokenBuffer.Token> buffered;
            {
                this.localNesting = LazyTokenBuffer.this.nesting();
                this.buffered = LazyTokenBuffer.super.lookahead();
            }

            @Override
            public TokenBuffer.Token get() {
                if (this.localNesting == 0) {
                    return null;
                }
                TokenBuffer.Token token = this.buffered.get();
                if (token == null) {
                    token = LazyTokenBuffer.this.nextToken();
                    LazyTokenBuffer.this.tokens.add(token);
                }
                this.localNesting += LazyTokenBuffer.this.nestingOffset(token.token);
                return token;
            }
        };
    }

    private TokenBuffer.Token nextToken() {
        try {
            JsonToken token = this.parser.nextValue();
            if (token == null) {
                throw new IllegalStateException("no more JSON tokens");
            }
            return new TokenBuffer.Token(token, this.parser.currentName(), this.parser.getText());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed reading document JSON", e);
        }
    }
}

