/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.TestAndSetCondition;
import com.yahoo.document.json.DocumentOperationType;
import com.yahoo.document.json.LazyTokenBuffer;
import com.yahoo.document.json.ParsedDocumentOperation;
import com.yahoo.document.json.document.DocumentParser;
import com.yahoo.document.json.readers.DocumentParseInfo;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.VespaJsonDocumentReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class JsonReader {
    private final JsonParser parser;
    private final DocumentTypeManager typeManager;
    private ReaderState state = ReaderState.AT_START;

    public JsonReader(DocumentTypeManager typeManager, InputStream input, JsonFactory parserFactory) {
        this.typeManager = typeManager;
        try {
            this.parser = parserFactory.createParser(input);
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new IllegalArgumentException(e);
        }
    }

    public Optional<DocumentParseInfo> parseDocument() throws IOException {
        DocumentParser documentParser = new DocumentParser(this.parser);
        return documentParser.parse(Optional.empty());
    }

    ParsedDocumentOperation readSingleDocument(DocumentOperationType operationType, String docIdString) {
        DocumentParseInfo documentParseInfo;
        DocumentId docId = new DocumentId(docIdString);
        try {
            DocumentParser documentParser = new DocumentParser(this.parser);
            documentParseInfo = documentParser.parse(Optional.of(docId)).get();
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new IllegalArgumentException(e);
        }
        documentParseInfo.operationType = operationType;
        VespaJsonDocumentReader vespaJsonDocumentReader = new VespaJsonDocumentReader(this.typeManager.getIgnoreUndefinedFields());
        ParsedDocumentOperation operation = vespaJsonDocumentReader.createDocumentOperation(JsonReader.getDocumentTypeFromString(documentParseInfo.documentId.getDocType(), this.typeManager), documentParseInfo);
        operation.operation().setCondition(TestAndSetCondition.fromConditionString(documentParseInfo.condition));
        return operation;
    }

    public ParsedDocumentOperation readSingleDocumentStreaming(DocumentOperationType operationType, String docIdString) {
        try {
            DocumentId docId = new DocumentId(docIdString);
            DocumentParseInfo documentParseInfo = new DocumentParseInfo();
            documentParseInfo.documentId = docId;
            documentParseInfo.operationType = operationType;
            if (JsonToken.START_OBJECT != this.parser.nextValue()) {
                throw new IllegalArgumentException("expected start of root object, got " + String.valueOf(this.parser.currentToken()));
            }
            Boolean create = null;
            String condition = null;
            ParsedDocumentOperation operation = null;
            block17: while (JsonToken.END_OBJECT != this.parser.nextValue()) {
                switch (this.parser.currentName()) {
                    case "fields": {
                        documentParseInfo.fieldsBuffer = new LazyTokenBuffer(this.parser);
                        VespaJsonDocumentReader vespaJsonDocumentReader = new VespaJsonDocumentReader(this.typeManager.getIgnoreUndefinedFields());
                        operation = vespaJsonDocumentReader.createDocumentOperation(JsonReader.getDocumentTypeFromString(documentParseInfo.documentId.getDocType(), this.typeManager), documentParseInfo);
                        if (documentParseInfo.fieldsBuffer.isEmpty()) continue block17;
                        throw new IllegalArgumentException("expected all content to be consumed by document parsing, but " + documentParseInfo.fieldsBuffer.nesting() + " levels remain");
                    }
                    case "condition": {
                        if (!JsonToken.VALUE_STRING.equals((Object)this.parser.currentToken()) && !JsonToken.VALUE_NULL.equals((Object)this.parser.currentToken())) {
                            throw new IllegalArgumentException("expected string value for condition, got " + String.valueOf(this.parser.currentToken()));
                        }
                        condition = this.parser.getValueAsString();
                        break;
                    }
                    case "create": {
                        create = this.parser.getBooleanValue();
                        break;
                    }
                    default: {
                        if (!this.parser.currentToken().isStructStart()) continue block17;
                        this.parser.skipChildren();
                    }
                }
            }
            if (null != this.parser.nextToken()) {
                throw new IllegalArgumentException("expected end of input, got " + String.valueOf(this.parser.currentToken()));
            }
            if (null == operation) {
                throw new IllegalArgumentException("document is missing the required \"fields\" field");
            }
            if (null != create) {
                switch (operationType) {
                    case PUT: {
                        ((DocumentPut)operation.operation()).setCreateIfNonExistent(create);
                        break;
                    }
                    case UPDATE: {
                        ((DocumentUpdate)operation.operation()).setCreateIfNonExistent(create);
                        break;
                    }
                    case REMOVE: {
                        throw new IllegalArgumentException("create is not supported for remove operations");
                    }
                }
            }
            operation.operation().setCondition(TestAndSetCondition.fromConditionString(Optional.ofNullable(condition)));
            return operation;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed parsing document", e);
        }
    }

    public DocumentOperation next() {
        Optional<DocumentParseInfo> documentParseInfo;
        switch (this.state) {
            case AT_START: {
                JsonToken t = this.nextToken(this.parser);
                JsonParserHelpers.expectArrayStart(t);
                this.state = ReaderState.READING;
                break;
            }
            case END_OF_FEED: {
                return null;
            }
        }
        try {
            documentParseInfo = this.parseDocument();
        }
        catch (IOException r) {
            this.state = ReaderState.END_OF_FEED;
            throw new IllegalArgumentException(r);
        }
        if (documentParseInfo.isEmpty()) {
            this.state = ReaderState.END_OF_FEED;
            return null;
        }
        VespaJsonDocumentReader vespaJsonDocumentReader = new VespaJsonDocumentReader(this.typeManager.getIgnoreUndefinedFields());
        DocumentOperation operation = vespaJsonDocumentReader.createDocumentOperation(JsonReader.getDocumentTypeFromString(documentParseInfo.get().documentId.getDocType(), this.typeManager), documentParseInfo.get()).operation();
        operation.setCondition(TestAndSetCondition.fromConditionString(documentParseInfo.get().condition));
        return operation;
    }

    public DocumentType readDocumentType(DocumentId docId) {
        return JsonReader.getDocumentTypeFromString(docId.getDocType(), this.typeManager);
    }

    private static DocumentType getDocumentTypeFromString(String docTypeString, DocumentTypeManager typeManager) {
        DocumentType docType = typeManager.getDocumentType(docTypeString);
        if (docType == null) {
            throw new IllegalArgumentException(String.format("Document type %s does not exist", docTypeString));
        }
        return docType;
    }

    public JsonToken nextToken(JsonParser parser) {
        try {
            return parser.nextValue();
        }
        catch (IOException e) {
            this.state = ReaderState.END_OF_FEED;
            throw new IllegalArgumentException(e);
        }
    }

    static enum ReaderState {
        AT_START,
        READING,
        END_OF_FEED;

    }
}

