/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.fieldset;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.fieldset.AllFields;
import com.yahoo.document.fieldset.DocIdOnly;
import com.yahoo.document.fieldset.DocumentOnly;
import com.yahoo.document.fieldset.FieldCollection;
import com.yahoo.document.fieldset.FieldSet;
import com.yahoo.document.fieldset.NoFields;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class FieldSetRepo {
    FieldSet parseSpecialValues(String name) {
        if (name.equals("[id]")) {
            return new DocIdOnly();
        }
        if (name.equals("[document]")) {
            return new DocumentOnly();
        }
        if (name.equals("[all]")) {
            return new AllFields();
        }
        if (name.equals("[none]")) {
            return new NoFields();
        }
        if (name.equals("[docid]")) {
            return new DocIdOnly();
        }
        throw new IllegalArgumentException("The only special names (enclosed in '[]') allowed are id, all, document, none");
    }

    FieldSet parseFieldCollection(DocumentTypeManager docMan, String docType, String fieldNames) {
        DocumentType type = docMan.getDocumentType(docType);
        if (type == null) {
            throw new IllegalArgumentException("Unknown document type " + docType);
        }
        FieldCollection collection = new FieldCollection(type);
        if (fieldNames.equals("[document]")) {
            collection.addAll(type.fieldSet());
        } else {
            StringTokenizer tokenizer = new StringTokenizer(fieldNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                Field f = type.getField(token);
                if (f == null) {
                    throw new IllegalArgumentException("No such field " + token);
                }
                collection.add(f);
            }
        }
        return collection;
    }

    public FieldSet parse(DocumentTypeManager docMan, String fieldSet) {
        if (fieldSet.length() == 0) {
            throw new IllegalArgumentException("Illegal field set value \"\"");
        }
        if (fieldSet.startsWith("[")) {
            return this.parseSpecialValues(fieldSet);
        }
        StringTokenizer tokenizer = new StringTokenizer(fieldSet, ":");
        if (tokenizer.countTokens() != 2) {
            throw new IllegalArgumentException("The field set list must consist of a document type, then a colon (:), then a comma-separated list of field names");
        }
        String type = tokenizer.nextToken();
        String fields = tokenizer.nextToken();
        return this.parseFieldCollection(docMan, type, fields);
    }

    public String serialize(FieldSet fieldSet) {
        if (fieldSet instanceof Field) {
            return ((Field)fieldSet).getName();
        }
        if (fieldSet instanceof FieldCollection) {
            FieldCollection c = (FieldCollection)fieldSet;
            StringBuilder buffer = new StringBuilder();
            for (Field f : c) {
                if (buffer.length() == 0) {
                    buffer.append(c.getDocumentType().getName());
                    buffer.append(":");
                } else {
                    buffer.append(",");
                }
                buffer.append(f.getName());
            }
            return buffer.toString();
        }
        if (fieldSet instanceof AllFields) {
            return "[all]";
        }
        if (fieldSet instanceof NoFields) {
            return "[none]";
        }
        if (fieldSet instanceof DocIdOnly) {
            return "[id]";
        }
        if (fieldSet instanceof DocumentOnly) {
            return "[document]";
        }
        throw new IllegalArgumentException("Unknown field set type " + String.valueOf(fieldSet));
    }

    public void copyFields(Document source, Document target, FieldSet fieldSet) {
        Set<Field> actual;
        if (fieldSet instanceof DocumentOnly && (actual = source.getDataType().fieldSet("[document]")) != null) {
            Iterator<Map.Entry<Field, FieldValue>> i = source.iterator();
            while (i.hasNext()) {
                Map.Entry<Field, FieldValue> v = i.next();
                if (!actual.contains(v.getKey())) continue;
                target.setFieldValue(v.getKey(), v.getValue());
            }
            return;
        }
        Iterator<Map.Entry<Field, FieldValue>> i = source.iterator();
        while (i.hasNext()) {
            Map.Entry<Field, FieldValue> v = i.next();
            if (!fieldSet.contains(v.getKey())) continue;
            target.setFieldValue(v.getKey(), v.getValue());
        }
    }

    public void stripFields(Document target, FieldSet fieldSet) {
        Set<Field> actual;
        ArrayList<Field> toStrip = new ArrayList<Field>();
        if (fieldSet instanceof DocumentOnly && (actual = target.getDataType().fieldSet("[document]")) != null) {
            Iterator<Map.Entry<Field, FieldValue>> i = target.iterator();
            while (i.hasNext()) {
                Map.Entry<Field, FieldValue> v = i.next();
                if (actual.contains(v.getKey())) continue;
                toStrip.add(v.getKey());
            }
            for (Field f : toStrip) {
                target.removeFieldValue(f);
            }
            return;
        }
        Iterator<Map.Entry<Field, FieldValue>> i = target.iterator();
        while (i.hasNext()) {
            Map.Entry<Field, FieldValue> v = i.next();
            if (fieldSet.contains(v.getKey())) continue;
            toStrip.add(v.getKey());
        }
        for (Field f : toStrip) {
            target.removeFieldValue(f);
        }
    }
}

