/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class StructuredDataType
extends DataType {
    public static final int classId = StructuredDataType.registerClass((int)4152, StructuredDataType.class);

    protected static int createId(String name) {
        if (name.equals("document")) {
            return 8;
        }
        return (name + ".0").hashCode();
    }

    public StructuredDataType(String name) {
        super(name, StructuredDataType.createId(name));
    }

    public StructuredDataType(int id, String name) {
        super(name, id);
    }

    @Override
    public abstract StructuredFieldValue createFieldValue();

    @Override
    protected FieldValue createByReflection(Object arg) {
        return null;
    }

    public DataTypeName getDataTypeName() {
        return new DataTypeName(this.getName());
    }

    public abstract Field getField(String var1);

    public abstract Field getField(int var1);

    public abstract Collection<Field> getFields();

    @Override
    public boolean equals(Object o) {
        return o instanceof StructuredDataType && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void register(DocumentTypeManager manager, List<DataType> seenTypes) {
        seenTypes.add(this);
        for (Field field : this.getFields()) {
            if (seenTypes.contains(field.getDataType())) continue;
            field.getDataType().register(manager, seenTypes);
        }
        super.register(manager, seenTypes);
    }

    @Override
    public FieldPath buildFieldPath(String remainFieldName) {
        Field f;
        if (remainFieldName.isEmpty()) {
            return new FieldPath();
        }
        String currFieldName = remainFieldName;
        String subFieldName = "";
        for (int i = 0; i < remainFieldName.length(); ++i) {
            if (remainFieldName.charAt(i) == '.') {
                currFieldName = remainFieldName.substring(0, i);
                subFieldName = remainFieldName.substring(i + 1);
                break;
            }
            if (remainFieldName.charAt(i) != '{' && remainFieldName.charAt(i) != '[') continue;
            currFieldName = remainFieldName.substring(0, i);
            subFieldName = remainFieldName.substring(i);
            break;
        }
        if ((f = this.getField(currFieldName)) != null) {
            FieldPath fieldPath = f.getDataType().buildFieldPath(subFieldName);
            ArrayList<FieldPathEntry> tmpPath = new ArrayList<FieldPathEntry>(fieldPath.getList());
            tmpPath.add(0, FieldPathEntry.newStructFieldEntry(f));
            return new FieldPath(tmpPath);
        }
        throw new IllegalArgumentException("Field '" + currFieldName + "' not found in " + String.valueOf(this));
    }
}

