/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.FieldPath;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import java.util.ArrayList;
import java.util.List;

public class MapDataType
extends DataType {
    private DataType keyType;
    private DataType valueType;

    public MapDataType(DataType keyType, DataType valueType, int id) {
        super("Map<" + keyType.getName() + "," + valueType.getName() + ">", id);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public MapDataType(DataType keyType, DataType valueType) {
        this(keyType, valueType, 0);
        this.setId(this.getName().toLowerCase().hashCode());
    }

    @Override
    public MapDataType clone() {
        MapDataType type = (MapDataType)super.clone();
        type.keyType = this.keyType.clone();
        type.valueType = this.valueType.clone();
        return type;
    }

    @Override
    protected FieldValue createByReflection(Object arg) {
        return null;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (!(value instanceof MapFieldValue)) {
            return false;
        }
        MapFieldValue mapValue = (MapFieldValue)value;
        if (mapValue.getDataType().getClass() != this.getClass()) {
            return false;
        }
        return mapValue.getDataType().getKeyType().isAssignableTo(this.getKeyType()) && mapValue.getDataType().getValueType().isAssignableTo(this.getValueType());
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public MapFieldValue createFieldValue() {
        return new MapFieldValue(this);
    }

    @Override
    public Class getValueClass() {
        return MapFieldValue.class;
    }

    @Override
    protected void register(DocumentTypeManager manager, List<DataType> seenTypes) {
        seenTypes.add(this);
        if (!seenTypes.contains(this.getKeyType())) {
            this.getKeyType().register(manager, seenTypes);
        }
        if (!seenTypes.contains(this.getValueType())) {
            this.getValueType().register(manager, seenTypes);
        }
        super.register(manager, seenTypes);
    }

    public static FieldPath buildFieldPath(String remainFieldName, DataType keyType, DataType valueType) {
        if (remainFieldName.length() > 0 && remainFieldName.charAt(0) == '{') {
            FieldPathEntry.KeyParseResult result = FieldPathEntry.parseKey(remainFieldName);
            String keyValue = result.parsed;
            FieldPath path = valueType.buildFieldPath(MapDataType.skipDotInString(remainFieldName, result.consumedChars - 1));
            ArrayList<FieldPathEntry> tmpPath = new ArrayList<FieldPathEntry>(path.getList());
            if (remainFieldName.charAt(1) == '$') {
                tmpPath.add(0, FieldPathEntry.newVariableLookupEntry(keyValue.substring(1), valueType));
            } else {
                FieldValue fv = keyType.createFieldValue();
                fv.assign(keyValue);
                tmpPath.add(0, FieldPathEntry.newMapLookupEntry(fv, valueType));
            }
            return new FieldPath(tmpPath);
        }
        if (remainFieldName.startsWith("key")) {
            FieldPath path = keyType.buildFieldPath(MapDataType.skipDotInString(remainFieldName, 2));
            ArrayList<FieldPathEntry> tmpPath = new ArrayList<FieldPathEntry>(path.getList());
            tmpPath.add(0, FieldPathEntry.newAllKeysLookupEntry(keyType));
            return new FieldPath(tmpPath);
        }
        if (remainFieldName.startsWith("value")) {
            FieldPath path = valueType.buildFieldPath(MapDataType.skipDotInString(remainFieldName, 4));
            ArrayList<FieldPathEntry> tmpPath = new ArrayList<FieldPathEntry>(path.getList());
            tmpPath.add(0, FieldPathEntry.newAllValuesLookupEntry(valueType));
            return new FieldPath(tmpPath);
        }
        return keyType.buildFieldPath(remainFieldName);
    }

    @Override
    public FieldPath buildFieldPath(String remainFieldName) {
        return MapDataType.buildFieldPath(remainFieldName, this.getKeyType(), this.getValueType());
    }

    @Override
    public boolean isMultivalue() {
        return true;
    }
}

