/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain.testutil;

import com.yahoo.net.URI;
import com.yahoo.prelude.fastsearch.PartialSummaryHandler;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DocumentSourceSearcher
extends Searcher {
    public static final String DEFAULT_SUMMARY_CLASS = "default";
    private Result defaultFilledResult;
    private final Map<Query, Result> completelyFilledResults = new HashMap<Query, Result>();
    private final Map<Query, Result> unFilledResults = new HashMap<Query, Result>();
    private final Map<String, Set<String>> summaryClasses = new HashMap<String, Set<String>>();
    private int queryCount;

    public DocumentSourceSearcher() {
        this.addDefaultResults();
    }

    public boolean addResult(Query query, Result fullResult) {
        Result emptyResult = new Result(query.clone());
        emptyResult.setTotalHitCount(fullResult.getTotalHitCount());
        for (Hit fullHit : fullResult.hits().asList()) {
            Hit emptyHit = fullHit.clone();
            emptyHit.clearFields();
            emptyHit.setFillable();
            emptyHit.setRelevance(fullHit.getRelevance());
            emptyResult.hits().add(emptyHit);
        }
        this.unFilledResults.put(this.getQueryKeyClone(query), emptyResult);
        return this.completelyFilledResults.put(this.getQueryKeyClone(query), fullResult.clone()) != null;
    }

    public void addSummaryClass(String name, Set<String> fields) {
        this.summaryClasses.put(name, fields);
    }

    public void addSummaryClassByCopy(String name, Collection<String> fields) {
        this.addSummaryClass(name, new HashSet<String>(fields));
    }

    private void addDefaultResults() {
        Query q = new Query("?query=default");
        Result r = new Result(q);
        r.hits().add(new Hit("http://default-1.html", 0.0));
        r.hits().add(new Hit("http://default-2.html", 0.0));
        r.hits().add(new Hit("http://default-3.html", 0.0));
        r.hits().add(new Hit("http://default-4.html", 0.0));
        this.defaultFilledResult = r;
        this.addResult(q, r);
    }

    @Override
    public Result search(Query query, Execution execution) {
        ++this.queryCount;
        Result r = this.unFilledResults.get(this.getQueryKeyClone(query));
        r = r == null ? this.defaultFilledResult.clone() : r.clone();
        r.setQuery(query);
        r.hits().trim(query.getOffset(), query.getHits());
        query.setOffset(0);
        return r;
    }

    private Query getQueryKeyClone(Query query) {
        Query key = query.clone();
        key.setWindow(0, 0);
        key.getModel().setSources("");
        return key;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Result filledResult = this.completelyFilledResults.get(this.getQueryKeyClone(result.getQuery()));
        if (filledResult == null) {
            filledResult = this.defaultFilledResult;
        }
        this.fillHits(filledResult, result, summaryClass);
    }

    private void fillHits(Result filledHits, Result hitsToFill, String summaryClass) {
        Set<String> fieldsToFill = this.summaryClasses.get(summaryClass);
        if (fieldsToFill == null) {
            fieldsToFill = this.summaryClasses.get(DEFAULT_SUMMARY_CLASS);
        }
        PartialSummaryHandler partialSummaryHandler = new PartialSummaryHandler(this.summaryClasses);
        partialSummaryHandler.wantToFill(hitsToFill, summaryClass);
        Set<String> onlyFields = partialSummaryHandler.askForFields();
        if (onlyFields != null) {
            fieldsToFill = onlyFields;
        }
        for (Hit hitToFill : hitsToFill.hits()) {
            Hit filledHit = this.getMatchingFilledHit(hitToFill.getId(), filledHits);
            if (filledHit == null) continue;
            if (fieldsToFill != null) {
                this.copyFieldValuesThatExist(filledHit, hitToFill, fieldsToFill);
            } else {
                Iterator<Map.Entry<String, Object>> iter = filledHit.fieldIterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Object> propertyEntry = iter.next();
                    hitToFill.setField(propertyEntry.getKey(), propertyEntry.getValue());
                }
            }
            partialSummaryHandler.markFilled(hitToFill);
        }
        hitsToFill.analyzeHits();
    }

    private Hit getMatchingFilledHit(URI hitToFillId, Result filledHits) {
        Hit filledHit = null;
        for (Hit filledHitCandidate : filledHits.hits()) {
            if (hitToFillId != filledHitCandidate.getId()) continue;
            filledHit = filledHitCandidate;
            break;
        }
        return filledHit;
    }

    private void copyFieldValuesThatExist(Hit filledHit, Hit hitToFill, Set<String> fieldsToFill) {
        for (String fieldToFill : fieldsToFill) {
            if (filledHit.getField(fieldToFill) == null) continue;
            hitToFill.setField(fieldToFill, filledHit.getField(fieldToFill));
        }
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void resetQueryCount() {
        this.queryCount = 0;
    }
}

