/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.SpecialTokenRegistry;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.IndexModel;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.search.rendering.RendererRegistry;
import com.yahoo.search.schema.SchemaInfo;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.searchchain.RenderingExecutorFactory;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.vespa.configdefinition.SpecialtokensConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutionFactory
extends AbstractComponent {
    private final SearchChainRegistry searchChainRegistry;
    private final IndexFacts indexFacts;
    private final SchemaInfo schemaInfo;
    private final SpecialTokenRegistry specialTokens;
    private final Linguistics linguistics;
    private final ThreadPoolExecutor renderingExecutor;
    private final RendererRegistry rendererRegistry;
    private final Executor executor;

    @Inject
    public ExecutionFactory(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, SchemaInfoConfig schemaInfo, QrSearchersConfig clusters, ComponentRegistry<Searcher> searchers, SpecialtokensConfig specialTokens, Linguistics linguistics, ComponentRegistry<Renderer> renderers, Executor executor) {
        this(chainsConfig, indexInfo, new SchemaInfo(schemaInfo, clusters), clusters, searchers, specialTokens, linguistics, renderers, executor);
    }

    public ExecutionFactory(ChainsConfig chainsConfig, IndexInfoConfig indexInfo, SchemaInfo schemaInfo, QrSearchersConfig clusters, ComponentRegistry<Searcher> searchers, SpecialtokensConfig specialTokens, Linguistics linguistics, ComponentRegistry<Renderer> renderers, Executor executor) {
        this.searchChainRegistry = this.createSearchChainRegistry(searchers, chainsConfig);
        this.indexFacts = new IndexFacts(new IndexModel(indexInfo, clusters)).freeze();
        this.schemaInfo = schemaInfo;
        this.specialTokens = new SpecialTokenRegistry(specialTokens);
        this.linguistics = linguistics;
        this.renderingExecutor = new RenderingExecutorFactory().createExecutor();
        this.rendererRegistry = new RendererRegistry(renderers.allComponents(), this.renderingExecutor);
        this.executor = executor != null ? executor : Executors.newSingleThreadExecutor();
    }

    private SearchChainRegistry createSearchChainRegistry(ComponentRegistry<Searcher> searchers, ChainsConfig chainsConfig) {
        SearchChainRegistry searchChainRegistry = new SearchChainRegistry(searchers);
        ChainsModel chainsModel = ChainsModelBuilder.buildFromConfig((ChainsConfig)chainsConfig);
        ChainsConfigurer.prepareChainRegistry((ComponentRegistry)searchChainRegistry, (ChainsModel)chainsModel, searchers);
        searchChainRegistry.freeze();
        return searchChainRegistry;
    }

    public Execution newExecution(Chain<? extends Searcher> searchChain) {
        return new Execution(searchChain, new Execution.Context(this.searchChainRegistry, this.indexFacts, this.schemaInfo, this.specialTokens, this.rendererRegistry, this.linguistics, this.executor));
    }

    public Execution newExecution(String searchChainId) {
        return new Execution(this.searchChainRegistry().getChain(searchChainId), new Execution.Context(this.searchChainRegistry, this.indexFacts, this.schemaInfo, this.specialTokens, this.rendererRegistry, this.linguistics, this.executor));
    }

    public SearchChainRegistry searchChainRegistry() {
        return this.searchChainRegistry;
    }

    public RendererRegistry rendererRegistry() {
        return this.rendererRegistry;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    public void deconstruct() {
        this.rendererRegistry.deconstruct();
        this.renderingExecutor.shutdown();
        try {
            if (!this.renderingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.renderingExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.renderingExecutor.shutdownNow();
        }
    }

    public static ExecutionFactory empty() {
        return new ExecutionFactory(new ChainsConfig.Builder().build(), new IndexInfoConfig.Builder().build(), SchemaInfo.empty(), new QrSearchersConfig.Builder().build(), (ComponentRegistry<Searcher>)new ComponentRegistry(), new SpecialtokensConfig.Builder().build(), (Linguistics)new SimpleLinguistics(), (ComponentRegistry<Renderer>)new ComponentRegistry(), null);
    }
}

