/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FeatureData
implements Inspectable,
JsonProducer {
    private boolean mutated = false;
    private final com.yahoo.data.access.Inspector encodedValues;
    private Map<String, Tensor> values = null;

    public FeatureData(com.yahoo.data.access.Inspector encodedValues) {
        this.encodedValues = Objects.requireNonNull(encodedValues);
    }

    public FeatureData(Map<String, Tensor> values) {
        this.encodedValues = null;
        this.values = new LinkedHashMap<String, Tensor>(values);
    }

    public static FeatureData empty() {
        return new FeatureData(Value.empty());
    }

    public com.yahoo.data.access.Inspector inspect() {
        if (this.isEmpty()) {
            return Value.empty();
        }
        if (!this.mutated) {
            return this.encodedValues;
        }
        this.decodeAll();
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        for (Map.Entry<String, Tensor> entry : this.values.entrySet()) {
            if (entry.getValue().type().rank() == 0) {
                root.setDouble(entry.getKey(), entry.getValue().asDouble());
                continue;
            }
            root.setData(entry.getKey(), TypedBinaryFormat.encode((Tensor)entry.getValue()));
        }
        return new SlimeAdapter((Inspector)root);
    }

    public String toJson() {
        return this.toJson(new JsonFormat.EncodeOptions());
    }

    public String toJson(boolean tensorShortForm) {
        return this.toJson(new JsonFormat.EncodeOptions(tensorShortForm));
    }

    public String toJson(boolean tensorShortForm, boolean tensorDirectValues) {
        return this.toJson(new JsonFormat.EncodeOptions(tensorShortForm, tensorDirectValues));
    }

    public String toJson(JsonFormat.EncodeOptions tensorOptions) {
        return this.writeJson(tensorOptions, new StringBuilder()).toString();
    }

    public StringBuilder writeJson(StringBuilder target) {
        return this.writeJson(new JsonFormat.EncodeOptions(false, false, false), target);
    }

    private StringBuilder writeJson(JsonFormat.EncodeOptions tensorOptions, StringBuilder target) {
        if (this.isEmpty()) {
            return target.append("{}");
        }
        if (this.encodedValues != null && !this.mutated) {
            return JsonRender.render((Inspectable)this.encodedValues, (JsonRender.StringEncoder)new Encoder(target, true, tensorOptions));
        }
        this.decodeAll();
        return this.writeJson(this.values, tensorOptions, target);
    }

    private StringBuilder writeJson(Map<String, Tensor> values, JsonFormat.EncodeOptions tensorOptions, StringBuilder target) {
        target.append("{");
        for (Map.Entry<String, Tensor> entry : values.entrySet()) {
            target.append("\"").append(entry.getKey()).append("\":");
            if (entry.getValue().type().rank() == 0) {
                double value = entry.getValue().asDouble();
                if (Double.isFinite(value)) {
                    target.append(value);
                } else {
                    target.append("null");
                }
            } else {
                byte[] encodedTensor = JsonFormat.encode((Tensor)entry.getValue(), (JsonFormat.EncodeOptions)tensorOptions);
                target.append(new String(encodedTensor, StandardCharsets.UTF_8));
            }
            target.append(",");
        }
        if (!values.isEmpty()) {
            target.setLength(target.length() - 1);
        }
        target.append("}");
        return target;
    }

    private void decodeAll() {
        if (this.encodedValues == null) {
            return;
        }
        this.encodedValues.traverse((name, value) -> {
            if (!this.values.containsKey(name)) {
                this.values.put(name, this.decodeTensor(value));
            }
        });
    }

    public Double getDouble(String featureName) {
        Tensor value = this.getTensor(featureName);
        return value == null ? null : Double.valueOf(value.asDouble());
    }

    public Tensor getTensor(String featureName) {
        Tensor value;
        if (this.values == null) {
            this.values = new LinkedHashMap<String, Tensor>();
        }
        if ((value = this.values.get(featureName)) != null) {
            return value;
        }
        if (this.encodedValues != null) {
            value = this.decodeTensor(featureName);
        }
        if (value != null) {
            this.values.put(featureName, value);
        }
        return value;
    }

    public void set(String featureName, Tensor value) {
        this.mutated = true;
        if (this.values == null) {
            this.values = new LinkedHashMap<String, Tensor>();
        }
        this.values.put(featureName, value);
    }

    public void set(String featureName, double value) {
        this.set(featureName, Tensor.from((double)value));
    }

    public boolean isEmpty() {
        return !(this.encodedValues != null && this.encodedValues.type() != Type.EMPTY || this.values != null && !this.values.isEmpty());
    }

    private Tensor decodeTensor(String featureName) {
        return this.decodeTensor(this.getInspector(featureName));
    }

    private Tensor decodeTensor(com.yahoo.data.access.Inspector featureValue) {
        if (!featureValue.valid()) {
            return null;
        }
        return switch (featureValue.type()) {
            case Type.DOUBLE -> Tensor.from((double)featureValue.asDouble());
            case Type.DATA -> FeatureData.tensorFromData(featureValue.asData());
            default -> throw new IllegalStateException("Unexpected feature value type " + String.valueOf(featureValue.type()));
        };
    }

    private com.yahoo.data.access.Inspector getInspector(String featureName) {
        com.yahoo.data.access.Inspector featureValue = this.encodedValues.field(featureName);
        if (featureValue.valid()) {
            return featureValue;
        }
        return this.encodedValues.field(Reference.wrapInRankingExpression((String)featureName));
    }

    public Set<String> featureNames() {
        if (this.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<String> featureNames = new LinkedHashSet<String>();
        if (this.encodedValues != null) {
            this.encodedValues.fields().forEach(field -> featureNames.add((String)field.getKey()));
        }
        if (this.values != null) {
            featureNames.addAll(this.values.keySet());
        }
        return featureNames;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.toJson();
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureData)) {
            return false;
        }
        return ((FeatureData)other).toJson().equals(this.toJson());
    }

    private static Tensor tensorFromData(byte[] value) {
        return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])value));
    }

    private static class Encoder
    extends JsonRender.StringEncoder {
        private final JsonFormat.EncodeOptions tensorOptions;

        Encoder(StringBuilder out, boolean compact, JsonFormat.EncodeOptions tensorOptions) {
            super(out, compact);
            this.tensorOptions = tensorOptions;
        }

        public void encodeDATA(byte[] value) {
            Tensor tensor = FeatureData.tensorFromData(value);
            byte[] encodedTensor = JsonFormat.encode((Tensor)tensor, (JsonFormat.EncodeOptions)this.tensorOptions);
            this.target().append(new String(encodedTensor, StandardCharsets.UTF_8));
        }
    }
}

