/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.disclosure.DataSink;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

class JsonGeneratorDataSink
implements DataSink {
    private static final byte[] HEX_DIGITS_ASCII = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    private static final boolean RAW_AS_BASE64_DISABLED = false;
    private JsonGenerator gen;
    private boolean wantUtf8;
    boolean enableRawAsBase64;
    private final Base64Variant base64Variant = Base64Variants.getDefaultVariant();

    public JsonGeneratorDataSink(JsonGenerator gen) {
        this(gen, false);
    }

    public JsonGeneratorDataSink(JsonGenerator gen, boolean enableRawAsBase64) {
        this.gen = gen;
        this.wantUtf8 = gen instanceof UTF8JsonGenerator;
        this.enableRawAsBase64 = enableRawAsBase64;
    }

    public void fieldName(String utf16, byte[] utf8) {
        try {
            if (utf16 != null) {
                this.gen.writeFieldName(utf16);
            } else {
                this.gen.writeFieldName(new String(utf8, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void startObject() {
        try {
            this.gen.writeStartObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endObject() {
        try {
            this.gen.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void startArray() {
        try {
            this.gen.writeStartArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void endArray() {
        try {
            this.gen.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void emptyValue() {
        try {
            this.gen.writeNull();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void booleanValue(boolean v) {
        try {
            this.gen.writeBoolean(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void longValue(long v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void intValue(int v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void shortValue(short v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void byteValue(byte v) {
        try {
            this.gen.writeNumber((short)v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void doubleValue(double v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void floatValue(float v) {
        try {
            this.gen.writeNumber(v);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void stringValue(String utf16, byte[] utf8) {
        try {
            if (this.wantUtf8) {
                if (utf8 != null) {
                    this.gen.writeUTF8String(utf8, 0, utf8.length);
                } else {
                    this.gen.writeString(utf16);
                }
            } else if (utf16 != null) {
                this.gen.writeString(utf16);
            } else {
                this.gen.writeString(new String(utf8, StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void dataValue(byte[] data) {
        try {
            if (this.enableRawAsBase64) {
                this.gen.writeBinary(this.base64Variant, data, 0, data.length);
            } else if (this.wantUtf8) {
                this.gen.writeUTF8String(JsonGeneratorDataSink.toHexUtf8(data), 0, 2 + data.length * 2);
            } else {
                this.gen.writeString(JsonGeneratorDataSink.toHexString(data));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] toHexUtf8(byte[] data) {
        byte[] out = new byte[2 + data.length * 2];
        int p = 0;
        out[p++] = 48;
        out[p++] = 120;
        for (byte b : data) {
            int v = b & 0xFF;
            out[p++] = HEX_DIGITS_ASCII[v >>> 4];
            out[p++] = HEX_DIGITS_ASCII[v & 0xF];
        }
        return out;
    }

    private static String toHexString(byte[] data) {
        char[] chars = new char[2 + data.length * 2];
        int p = 0;
        chars[p++] = 48;
        chars[p++] = 120;
        for (byte b : data) {
            int v = b & 0xFF;
            chars[p++] = (char)HEX_DIGITS_ASCII[v >>> 4];
            chars[p++] = (char)HEX_DIGITS_ASCII[v & 0xF];
        }
        return new String(chars);
    }

    void fieldNameFromPrimitive(Inspector value) {
        try {
            switch (value.type()) {
                case STRING: {
                    this.gen.writeFieldName(value.asString());
                    break;
                }
                case LONG: {
                    this.gen.writeFieldName(Long.toString(value.asLong()));
                    break;
                }
                case DOUBLE: {
                    this.gen.writeFieldName(Double.toString(value.asDouble()));
                    break;
                }
                case BOOL: {
                    this.gen.writeFieldName(value.asBool() ? "true" : "false");
                    break;
                }
                case DATA: {
                    if (this.enableRawAsBase64) {
                        this.gen.writeFieldName(this.base64Variant.encode(value.asData()));
                        break;
                    }
                    this.gen.writeFieldName(JsonGeneratorDataSink.toHexString(value.asData()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot use " + String.valueOf(value.type()) + " as field name");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

