/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.search.Result;
import com.yahoo.search.rendering.JsonRenderer;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.EventStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;

public class EventRenderer
extends AsynchronousSectionedRenderer<Result> {
    private static final JsonFactory generatorFactory = EventRenderer.createGeneratorFactory();
    private volatile JsonGenerator generator;
    private static final boolean RENDER_EVENT_HEADER = true;
    private static final boolean RENDER_END_EVENT = true;

    private static JsonFactory createGeneratorFactory() {
        JsonFactory factory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build())).build();
        factory.setCodec((ObjectCodec)new ObjectMapper(factory).disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE));
        return factory;
    }

    public EventRenderer() {
        this(null);
    }

    public EventRenderer(Executor executor) {
        super(executor);
    }

    public void beginResponse(OutputStream outputStream) throws IOException {
        this.generator = generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        this.generator.setRootValueSeparator((SerializableString)new SerializedString(""));
    }

    public void beginList(DataList<?> dataList) throws IOException {
    }

    public void data(Data data) throws IOException {
        if (data instanceof EventStream.ErrorEvent) {
            EventStream.ErrorEvent errorEvent = (EventStream.ErrorEvent)data;
            this.renderError(errorEvent.asError());
        } else if (data instanceof ErrorHit) {
            ErrorHit errorHit = (ErrorHit)data;
            for (ErrorMessage error : errorHit.errors()) {
                this.renderError(error);
            }
        } else if (data instanceof EventStream.Event) {
            EventStream.Event event = (EventStream.Event)data;
            this.generator.writeRaw("event: " + event.type() + "\n");
            this.generator.writeRaw("data: ");
            if (event.type().equals("hits")) {
                this.generator.writeRaw(event.toString());
            } else {
                this.generator.writeStartObject();
                this.generator.writeStringField(event.type(), event.toString());
                this.generator.writeEndObject();
            }
            this.generator.writeRaw("\n\n");
            this.generator.flush();
        }
    }

    private void renderError(ErrorMessage error) throws IOException {
        this.generator.writeRaw("event: error\n");
        this.generator.writeRaw("data: ");
        JsonRenderer.renderError(this.generator, error);
        this.generator.writeRaw("\n\n");
        this.generator.flush();
    }

    public void endList(DataList<?> dataList) throws IOException {
    }

    public void endResponse() throws IOException {
        this.generator.writeRaw("event: end\n");
        this.generator.close();
    }

    public String getEncoding() {
        return "utf-8";
    }

    public String getMimeType() {
        return "text/event-stream";
    }
}

