/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.fs4.MapEncoder;
import com.yahoo.tensor.Tensor;
import com.yahoo.text.JSON;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RankProperties
implements Cloneable {
    private final Map<String, List<Object>> properties;

    public RankProperties() {
        this(new LinkedHashMap<String, List<Object>>());
    }

    private RankProperties(Map<String, List<Object>> properties) {
        this.properties = properties;
    }

    public void put(String name, String value) {
        this.put(name, (Object)value);
    }

    public void put(String name, Object value) {
        List list = this.properties.computeIfAbsent(name, k -> new ArrayList());
        list.add(value);
    }

    public List<String> get(String name) {
        List<Object> values = this.properties.get(name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        for (Object value : values) {
            stringValues.add(value.toString());
        }
        return Collections.unmodifiableList(stringValues);
    }

    public Optional<Tensor> getAsTensor(String name) {
        List<Object> values = this.properties.get(name);
        if (values == null || values.isEmpty()) {
            return Optional.empty();
        }
        if (values.size() != 1) {
            throw new IllegalArgumentException("unexpected multiple [" + values.size() + "] values for property '" + name + "'");
        }
        Object feature = values.get(0);
        if (feature == null) {
            return Optional.empty();
        }
        if (feature instanceof Tensor) {
            Tensor t = (Tensor)feature;
            return Optional.of(t);
        }
        if (feature instanceof Double) {
            Double d = (Double)feature;
            return Optional.of(Tensor.from((double)d));
        }
        throw new IllegalArgumentException("Expected '" + name + "' to be a tensor or double, but it is '" + String.valueOf(feature) + "', this usually means that '" + name + "' is not defined in the schema. See https://docs.vespa.ai/en/ranking/tensor-user-guide.html#querying-with-tensors");
    }

    public void remove(String name) {
        this.properties.remove(name);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Map<String, List<Object>> asMap() {
        return this.properties;
    }

    public int encode(ByteBuffer buffer, boolean encodeQueryData) {
        if (encodeQueryData) {
            return MapEncoder.encodeMultiMap("rank", this.properties, buffer);
        }
        List<Object> sessionId = this.properties.get("sessionId");
        if (sessionId == null) {
            return 0;
        }
        return MapEncoder.encodeSingleValue("rank", "sessionId", sessionId.get(0), buffer);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RankProperties)) {
            return false;
        }
        return this.properties.equals(((RankProperties)other).properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public RankProperties clone() {
        LinkedHashMap<String, List<Object>> clone = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, List<Object>> entry : this.properties.entrySet()) {
            clone.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return new RankProperties(clone);
    }

    public String toString() {
        return JSON.encode(this.properties);
    }
}

