/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.fs4.MapEncoder;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.tensor.Tensor;
import com.yahoo.text.JSON;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;

public class RankFeatures
implements Cloneable {
    private final Ranking parent;
    private final Map<String, Object> features;
    private static final Map<String, CompoundName> compoundNameCache = new CopyOnWriteHashMap();

    public RankFeatures(Ranking parent) {
        this(parent, new LinkedHashMap<String, Object>());
    }

    private RankFeatures(Ranking parent, Map<String, Object> features) {
        this.parent = parent;
        this.features = features;
    }

    public void put(String name, double value) {
        this.features.put(name, value);
    }

    public void put(String name, Tensor value) {
        this.verifyType(name, value);
        if (value.type().rank() == 0) {
            this.features.put(name, value.asDouble());
        } else {
            this.features.put(name, value);
        }
    }

    private void verifyType(String name, Object value) {
        this.parent.getParent().properties().requireSettable(compoundNameCache.computeIfAbsent(name, key -> new CompoundName(List.of("ranking", "features", key))), value, Map.of());
    }

    public void put(String name, String value) {
        this.features.put(name, value);
    }

    public Object getObject(String name) {
        return this.features.get(name);
    }

    public OptionalDouble getDouble(String name) {
        Object feature = this.features.get(name);
        if (feature == null) {
            return OptionalDouble.empty();
        }
        if (feature instanceof Double) {
            return OptionalDouble.of((Double)feature);
        }
        throw new IllegalArgumentException("Expected '" + name + "' to be a double, but it is " + (feature instanceof Tensor ? "the tensor " + ((Tensor)feature).toAbbreviatedString() : "the string '" + String.valueOf(feature) + "'"));
    }

    public Optional<Tensor> getTensor(String name) {
        Object feature = this.features.get(name);
        if (feature == null) {
            return Optional.empty();
        }
        if (feature instanceof Tensor) {
            return Optional.of((Tensor)feature);
        }
        if (feature instanceof Double) {
            return Optional.of(Tensor.from((double)((Double)feature)));
        }
        throw new IllegalArgumentException("Expected '" + name + "' to be a tensor, but it is a string. Unless you set this to a string in code, this is because '" + name + "' is not defined in the schema for the chosen rank profile (" + this.parent.getProfile() + "), see https://docs.vespa.ai/en/ranking/tensor-user-guide.html#querying-with-tensors. The full string value is '" + String.valueOf(feature) + "'.");
    }

    public Optional<String> getString(String name) {
        Object feature = this.features.get(name);
        if (feature == null) {
            return Optional.empty();
        }
        if (feature instanceof String) {
            return Optional.of((String)feature);
        }
        throw new IllegalArgumentException("Expected '" + name + "' to be a string, but it is " + (feature instanceof Tensor ? "the tensor " + ((Tensor)feature).toAbbreviatedString() : "the double " + String.valueOf(feature)));
    }

    public Map<String, Object> asMap() {
        return this.features;
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public void prepare(RankProperties rankProperties) {
        if (this.isEmpty()) {
            return;
        }
        ArrayList<String> featuresToRemove = new ArrayList<String>();
        ArrayList<String> propertiesToInsert = new ArrayList<String>();
        for (String key : this.features.keySet()) {
            if (key.startsWith("query(") && key.endsWith(")")) {
                featuresToRemove.add(key);
                propertiesToInsert.add(key.substring("query(".length(), key.length() - 1));
                continue;
            }
            if (!key.startsWith("$")) continue;
            featuresToRemove.add(key);
            propertiesToInsert.add(key.substring(1));
        }
        for (int i = 0; i < featuresToRemove.size(); ++i) {
            rankProperties.put((String)propertiesToInsert.get(i), this.features.remove(featuresToRemove.get(i)));
        }
    }

    public int encode(ByteBuffer buffer) {
        return MapEncoder.encodeMap("feature", this.features, buffer);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RankFeatures)) {
            return false;
        }
        return this.features.equals(((RankFeatures)other).features);
    }

    public int hashCode() {
        return this.features.hashCode();
    }

    public RankFeatures clone() {
        return new RankFeatures(this.parent, new LinkedHashMap<String, Object>(this.features));
    }

    public RankFeatures cloneFor(Ranking parent) {
        return new RankFeatures(parent, new LinkedHashMap<String, Object>(this.features));
    }

    public String toString() {
        return JSON.encode(this.features);
    }

    public static boolean isFeatureName(String fullPropertyName) {
        return fullPropertyName.startsWith("ranking.features.") || fullPropertyName.startsWith("rankfeature.") || fullPropertyName.startsWith("featureoverride.") || fullPropertyName.startsWith("input.");
    }
}

