/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.logging;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.search.logging.AbstractThreadedLogger;
import com.yahoo.search.logging.LoggerEntry;
import com.yahoo.search.logging.Spooler;
import java.time.Clock;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSpoolingLogger
extends AbstractThreadedLogger
implements Runnable {
    protected static final Logger log = Logger.getLogger(AbstractSpoolingLogger.class.getName());
    private final ScheduledExecutorService executorService;
    private final AtomicBoolean executorStarted = new AtomicBoolean(false);
    protected final Spooler spooler;

    public AbstractSpoolingLogger() {
        this(new Spooler(Clock.systemUTC(), 100));
    }

    public AbstractSpoolingLogger(int maxFailures) {
        this(new Spooler(Clock.systemUTC(), maxFailures));
    }

    public AbstractSpoolingLogger(Spooler spooler) {
        this.spooler = spooler;
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("AbstractSpoolingLogger-send-"));
        this.start();
    }

    public void start() {
        if (!this.executorStarted.get()) {
            this.executorService.scheduleWithFixedDelay(this, 10L, 1L, TimeUnit.SECONDS);
            this.executorStarted.set(true);
        }
    }

    @Override
    public void run() {
        try {
            this.spooler.switchFileIfNeeded();
            this.spooler.processFiles(this::transport);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when processing files: " + e.getMessage());
        }
    }

    @Override
    public boolean send(LoggerEntry entry) {
        log.log(Level.FINE, "Sending entry " + String.valueOf(entry) + " to spooler");
        try {
            this.executor.execute(() -> this.spooler.write(entry));
        }
        catch (RejectedExecutionException e) {
            return false;
        }
        return true;
    }

    @Deprecated
    public void shutdown() {
        this.deconstruct();
    }

    @Override
    public void deconstruct() {
        super.deconstruct();
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                log.log(Level.WARNING, "Timeout elapsed waiting for termination");
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Failure when waiting for termination: " + e.getMessage());
        }
        this.run();
    }
}

