/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.request.AllOperation;
import com.yahoo.search.grouping.request.EachOperation;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.request.NegFunction;
import com.yahoo.search.grouping.vespa.ExpressionConverter;
import com.yahoo.search.grouping.vespa.GroupingTransform;
import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.ExpressionCountAggregationResult;
import com.yahoo.searchlib.aggregation.Group;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.searchlib.aggregation.GroupingLevel;
import com.yahoo.searchlib.aggregation.HitsAggregationResult;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.searchlib.expression.RangeBucketPreDefFunctionNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.TimeZone;

class RequestBuilder {
    private static final int LOOKAHEAD = 1;
    private final ExpressionConverter converter = new ExpressionConverter();
    private final List<Grouping> requestList = new LinkedList<Grouping>();
    private final GroupingTransform transform;
    private GroupingOperation root;
    private int tag = 0;
    private int defaultMaxHits = -1;
    private int defaultMaxGroups = -1;
    private long globalMaxGroups = -1L;
    private long totalGroupsAndSummaries = -1L;
    private double defaultPrecisionFactor = -1.0;

    public RequestBuilder(int requestId) {
        this.transform = new GroupingTransform(requestId);
    }

    public RequestBuilder setRootOperation(GroupingOperation root) {
        Objects.requireNonNull(root, "Root must be non-null");
        this.root = root;
        return this;
    }

    public RequestBuilder setTimeZone(TimeZone timeZone) {
        this.converter.setTimeOffset(timeZone != null ? timeZone.getOffset(System.currentTimeMillis()) : 0);
        return this;
    }

    public RequestBuilder setDefaultSummaryName(String summaryName) {
        this.converter.setDefaultSummaryName(summaryName != null ? summaryName : "");
        return this;
    }

    public GroupingTransform getTransform() {
        return this.transform;
    }

    public List<Grouping> getRequestList() {
        return this.requestList;
    }

    public void build() {
        if (this.tag != 0) {
            throw new IllegalStateException();
        }
        this.root.resolveLevel(1);
        Grouping grouping = new Grouping();
        grouping.getRoot().setTag(++this.tag);
        grouping.setForceSinglePass(this.root.getForceSinglePass() || this.root.containsHint("singlepass"));
        ArrayDeque<BuildFrame> stack = new ArrayDeque<BuildFrame>();
        stack.push(new BuildFrame(grouping, new BuildState(), this.root));
        while (!stack.isEmpty()) {
            BuildFrame frame = (BuildFrame)stack.pop();
            this.processRequestNode(frame);
            List<GroupingOperation> children = frame.astNode.getChildren();
            if (children.isEmpty()) {
                this.requestList.add(frame.grouping);
                continue;
            }
            int i = children.size();
            while (--i >= 0) {
                Grouping childGrouping = i == 0 ? frame.grouping : frame.grouping.clone();
                BuildState childState = i == 0 ? frame.state : new BuildState(frame.state);
                BuildFrame child = new BuildFrame(childGrouping, childState, children.get(i));
                stack.push(child);
            }
        }
        this.pruneRequests();
        this.validateGlobalMax();
    }

    public RequestBuilder addContinuations(Iterable<Continuation> continuations) {
        for (Continuation continuation : continuations) {
            if (continuation == null) continue;
            this.transform.addContinuation(continuation);
        }
        return this;
    }

    public RequestBuilder setDefaultMaxGroups(int v) {
        this.defaultMaxGroups = v;
        return this;
    }

    public RequestBuilder setDefaultMaxHits(int v) {
        this.defaultMaxHits = v;
        return this;
    }

    public RequestBuilder setGlobalMaxGroups(long v) {
        this.globalMaxGroups = v;
        return this;
    }

    public RequestBuilder setDefaultPrecisionFactor(double v) {
        this.defaultPrecisionFactor = v;
        return this;
    }

    OptionalLong totalGroupsAndSummaries() {
        return this.totalGroupsAndSummaries != -1L ? OptionalLong.of(this.totalGroupsAndSummaries) : OptionalLong.empty();
    }

    private void processRequestNode(BuildFrame frame) {
        int level = frame.astNode.getLevel();
        if (level > 2) {
            throw new IllegalInputException("Can not operate on " + GroupingOperation.getLevelDesc(level) + ".");
        }
        if (frame.astNode instanceof EachOperation) {
            this.resolveEach(frame);
        } else {
            this.resolveOutput(frame);
        }
        this.resolveState(frame);
        this.injectGroupByToExpressionCountAggregator(frame);
    }

    private void injectGroupByToExpressionCountAggregator(BuildFrame frame) {
        Group group = this.getLeafGroup(frame);
        group.getAggregationResults().stream().filter(aggr -> aggr instanceof ExpressionCountAggregationResult).forEach(aggr -> aggr.setExpression(frame.state.groupBy.clone()));
    }

    private void resolveEach(BuildFrame frame) {
        String label;
        int parentTag = this.getLeafGroup(frame).getTag();
        if (frame.state.groupBy != null) {
            GroupingLevel grpLevel = new GroupingLevel();
            grpLevel.getGroupPrototype().setTag(++this.tag);
            grpLevel.setExpression(frame.state.groupBy);
            frame.state.groupBy = null;
            int offset = this.transform.getOffset(this.tag);
            if (frame.state.precision != null) {
                grpLevel.setPrecision((long)(frame.state.precision + offset));
                frame.state.precision = null;
            }
            if (frame.state.max != null) {
                this.transform.putMax(this.tag, frame.state.max, "group list");
                grpLevel.setMaxGroups((long)(1 + frame.state.max + offset));
                frame.state.max = null;
            }
            if (frame.state.filterBy != null) {
                grpLevel.setFilter(frame.state.filterBy);
                frame.state.filterBy = null;
            }
            frame.grouping.getLevels().add(grpLevel);
        }
        if ((label = frame.astNode.getLabel()) != null) {
            frame.state.label = label;
        }
        if (frame.astNode.getLevel() > 0) {
            this.transform.putLabel(parentTag, this.getLeafGroup(frame).getTag(), frame.state.label, "group list");
        }
        this.resolveOutput(frame);
        if (!frame.state.orderByExp.isEmpty()) {
            GroupingLevel grpLevel = this.getLeafGroupingLevel(frame);
            int len = frame.state.orderByExp.size();
            for (int i = 0; i < len; ++i) {
                grpLevel.getGroupPrototype().addOrderBy(frame.state.orderByExp.get(i), frame.state.orderByAsc.get(i).booleanValue());
            }
            frame.state.orderByExp.clear();
            frame.state.orderByAsc.clear();
        }
    }

    private void resolveState(BuildFrame frame) {
        this.resolveGroupBy(frame);
        this.resolveFilterBy(frame);
        this.resolveMax(frame);
        this.resolveOrderBy(frame);
        this.resolvePrecision(frame);
        this.resolveWhere(frame);
    }

    private void resolveGroupBy(BuildFrame frame) {
        GroupingExpression exp = frame.astNode.getGroupBy();
        if (exp != null) {
            if (frame.state.groupBy != null) {
                throw new IllegalInputException("Can not group list of groups.");
            }
            frame.state.groupBy = this.converter.toExpressionNode(exp);
            frame.state.label = exp.toString();
        } else {
            int level = frame.astNode.getLevel();
            if (level != 0) {
                if (level == 1) {
                    frame.state.label = "hits";
                } else {
                    throw new IllegalInputException("Can not create anonymous " + GroupingOperation.getLevelDesc(level) + ".");
                }
            }
        }
    }

    private void resolveFilterBy(BuildFrame frame) {
        if (frame.astNode.getFilterBy() != null) {
            frame.state.filterBy = this.converter.toFilterExpressionNode(frame.astNode.getFilterBy());
        }
    }

    private long computeNewTopN(long oldMax, long newMax) {
        return oldMax < 0L ? newMax : Math.min(oldMax, newMax);
    }

    private void resolveMax(BuildFrame frame) {
        if (this.isTopNAllowed(frame)) {
            if (frame.astNode.hasMax() && !frame.astNode.hasUnlimitedMax()) {
                frame.grouping.setTopN(this.computeNewTopN(frame.grouping.getTopN(), frame.astNode.getMax()));
            }
        } else if (frame.astNode.hasUnlimitedMax()) {
            frame.state.max = null;
        } else if (frame.astNode.hasMax()) {
            frame.state.max = frame.astNode.getMax();
        } else if (frame.state.groupBy != null && this.defaultMaxGroups != -1) {
            frame.state.max = this.defaultMaxGroups;
        } else if (frame.state.groupBy == null && this.defaultMaxHits != -1) {
            frame.state.max = this.defaultMaxHits;
        }
    }

    private void resolveOrderBy(BuildFrame frame) {
        List<GroupingExpression> lst = frame.astNode.getOrderBy();
        if (lst == null || lst.isEmpty()) {
            return;
        }
        int reqLevel = frame.astNode.getLevel();
        if (reqLevel != 2) {
            throw new IllegalInputException("Can not order " + GroupingOperation.getLevelDesc(reqLevel) + " content.");
        }
        for (GroupingExpression exp : lst) {
            boolean asc = true;
            if (exp instanceof NegFunction) {
                asc = false;
                exp = ((NegFunction)exp).getArg(0);
            }
            frame.state.orderByExp.add(this.converter.toExpressionNode(exp));
            frame.state.orderByAsc.add(asc);
        }
    }

    private void resolveOutput(BuildFrame frame) {
        List<GroupingExpression> lst = frame.astNode.getOutputs();
        if (lst == null || lst.isEmpty()) {
            return;
        }
        Group group = this.getLeafGroup(frame);
        for (GroupingExpression exp : lst) {
            group.addAggregationResult(this.toAggregationResult(exp, group, frame));
        }
    }

    private AggregationResult toAggregationResult(GroupingExpression exp, Group group, BuildFrame frame) {
        AggregationResult result = this.converter.toAggregationResult(exp);
        result.setTag(++this.tag);
        String label = exp.getLabel();
        if (result instanceof HitsAggregationResult) {
            HitsAggregationResult hits = (HitsAggregationResult)result;
            if (label != null) {
                throw new IllegalInputException("Can not label expression '" + String.valueOf(exp) + "'.");
            }
            if (frame.state.max != null) {
                this.transform.putMax(this.tag, frame.state.max, "hit list");
                int offset = this.transform.getOffset(this.tag);
                hits.setMaxHits(1 + frame.state.max + offset);
                frame.state.max = null;
            }
            this.transform.putLabel(group.getTag(), this.tag, frame.state.label, "hit list");
        } else {
            this.transform.putLabel(group.getTag(), this.tag, label != null ? label : exp.toString(), "output");
        }
        return result;
    }

    private void resolvePrecision(BuildFrame frame) {
        int precision = frame.astNode.getPrecision();
        if (precision > 0) {
            frame.state.precision = precision;
        } else if (frame.state.max != null && this.defaultPrecisionFactor > 0.0) {
            frame.state.precision = Math.max(1, (int)Math.ceil((double)frame.state.max.intValue() * this.defaultPrecisionFactor));
        }
    }

    private void resolveWhere(BuildFrame frame) {
        String where = frame.astNode.getWhere();
        if (where != null) {
            if (!this.isRootOperation(frame)) {
                throw new IllegalInputException("Can not apply 'where' to non-root group.");
            }
            switch (where) {
                case "true": {
                    frame.grouping.setAll(true);
                    break;
                }
                case "$query": {
                    break;
                }
                default: {
                    throw new IllegalInputException("Operation 'where' does not support '" + where + "'.");
                }
            }
        }
    }

    private boolean isRootOperation(BuildFrame frame) {
        return frame.astNode == this.root && frame.state.groupBy == null;
    }

    private boolean isTopNAllowed(BuildFrame frame) {
        return frame.astNode instanceof AllOperation && frame.state.groupBy == null;
    }

    private GroupingLevel getLeafGroupingLevel(BuildFrame frame) {
        if (frame.grouping.getLevels().isEmpty()) {
            return null;
        }
        return (GroupingLevel)frame.grouping.getLevels().get(frame.grouping.getLevels().size() - 1);
    }

    private Group getLeafGroup(BuildFrame frame) {
        if (frame.grouping.getLevels().isEmpty()) {
            return frame.grouping.getRoot();
        }
        GroupingLevel grpLevel = this.getLeafGroupingLevel(frame);
        return grpLevel != null ? grpLevel.getGroupPrototype() : null;
    }

    private void pruneRequests() {
        int reqIdx = this.requestList.size();
        while (--reqIdx >= 0) {
            Grouping request = this.requestList.get(reqIdx);
            List lst = request.getLevels();
            int lvlIdx = lst.size();
            while (--lvlIdx >= 0 && ((GroupingLevel)lst.get(lvlIdx)).getGroupPrototype().getAggregationResults().isEmpty()) {
                lst.remove(lvlIdx);
            }
            if (!lst.isEmpty() || !request.getRoot().getAggregationResults().isEmpty()) continue;
            this.requestList.remove(reqIdx);
        }
    }

    private void validateGlobalMax() {
        if (this.globalMaxGroups < 0L) {
            return;
        }
        this.totalGroupsAndSummaries = -1L;
        int totalGroupsAndSummaries = 0;
        for (Grouping grp : this.requestList) {
            int levelMultiplier = 1;
            for (GroupingLevel lvl : grp.getLevels()) {
                totalGroupsAndSummaries += (levelMultiplier *= this.validateGroupMax(lvl));
                List<HitsAggregationResult> hars = this.hitsAggregationResult(lvl);
                for (HitsAggregationResult har : hars) {
                    totalGroupsAndSummaries += levelMultiplier * this.validateSummaryMax(har);
                }
            }
        }
        if ((long)totalGroupsAndSummaries > this.globalMaxGroups) {
            throw new IllegalInputException(String.format("The theoretical total number of groups and summaries in grouping query exceeds 'grouping.globalMaxGroups' ( %d > %d ). Either restrict group/summary counts with max() or disable 'grouping.globalMaxGroups'. See https://docs.vespa.ai/en/querying/grouping.html for details.", totalGroupsAndSummaries, this.globalMaxGroups));
        }
        this.totalGroupsAndSummaries = totalGroupsAndSummaries;
    }

    private int validateGroupMax(GroupingLevel lvl) {
        int maxBuckets;
        int max = this.transform.getMax(lvl.getGroupPrototype().getTag());
        if (lvl.getExpression() instanceof RangeBucketPreDefFunctionNode && ((maxBuckets = ((RangeBucketPreDefFunctionNode)lvl.getExpression()).getBucketList().size() + 1) < max || max <= 0)) {
            max = maxBuckets;
        }
        if (max <= 0) {
            throw new IllegalInputException("Cannot return unbounded number of groups when 'grouping.globalMaxGroups' is enabled. Either restrict group count with max() or disable 'grouping.globalMaxGroups'. See https://docs.vespa.ai/en/querying/grouping.html for details.");
        }
        return max;
    }

    private int validateSummaryMax(HitsAggregationResult res) {
        int max = this.transform.getMax(res.getTag());
        if (max <= 0) {
            throw new IllegalInputException("Cannot return unbounded number of summaries when 'grouping.globalMaxGroups' is enabled. Either restrict summary count with max() or disable 'grouping.globalMaxGroups'. See https://docs.vespa.ai/en/querying/grouping.html for details.");
        }
        return max;
    }

    private List<HitsAggregationResult> hitsAggregationResult(GroupingLevel lvl) {
        return lvl.getGroupPrototype().getAggregationResults().stream().filter(ar -> ar instanceof HitsAggregationResult).map(ar -> (HitsAggregationResult)ar).toList();
    }

    private static class BuildFrame {
        final Grouping grouping;
        final BuildState state;
        final GroupingOperation astNode;

        BuildFrame(Grouping grouping, BuildState state, GroupingOperation astNode) {
            this.grouping = grouping;
            this.state = state;
            this.astNode = astNode;
        }
    }

    private static class BuildState {
        final List<ExpressionNode> orderByExp = new ArrayList<ExpressionNode>();
        final List<Boolean> orderByAsc = new ArrayList<Boolean>();
        ExpressionNode groupBy = null;
        FilterExpressionNode filterBy = null;
        String label = null;
        Integer max = null;
        Integer precision = null;

        BuildState() {
        }

        BuildState(BuildState obj) {
            for (ExpressionNode e : obj.orderByExp) {
                this.orderByExp.add(e.clone());
            }
            this.orderByAsc.addAll(obj.orderByAsc);
            this.groupBy = obj.groupBy;
            this.filterBy = obj.filterBy;
            this.label = obj.label;
            this.max = obj.max;
            this.precision = obj.precision;
        }
    }
}

