/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.api.annotations.Beta;
import com.yahoo.collections.LazyMap;
import com.yahoo.collections.LazySet;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.FilterExpression;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingNode;
import com.yahoo.search.grouping.request.parser.GroupingParser;
import com.yahoo.search.grouping.request.parser.GroupingParserInput;
import com.yahoo.search.grouping.request.parser.ParseException;
import com.yahoo.search.grouping.request.parser.TokenMgrException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class GroupingOperation
extends GroupingNode {
    @Beta
    public static final int UNLIMITED_MAX = Integer.MAX_VALUE;
    private final List<GroupingExpression> orderBy = new ArrayList<GroupingExpression>();
    private final List<GroupingExpression> outputs = new ArrayList<GroupingExpression>();
    private final List<GroupingOperation> children = new ArrayList<GroupingOperation>();
    private final Map<String, GroupingExpression> aliases = LazyMap.newHashMap();
    private final Set<String> hints = LazySet.newHashSet();
    private GroupingExpression groupBy = null;
    private FilterExpression filterBy = null;
    private GroupingOperation parent = null;
    private String where = null;
    private boolean forceSinglePass = false;
    private double accuracy = 0.95;
    private int precision = 0;
    private int level = -1;
    private int max = -1;

    protected GroupingOperation(String image, String label) {
        super(image, label);
    }

    @Deprecated
    protected GroupingOperation(GroupingOperation parentOfCopy, String image, String label, List<GroupingExpression> orderBy, List<GroupingExpression> outputs, List<GroupingOperation> children, Map<String, GroupingExpression> aliases, Set<String> hints, GroupingExpression groupBy, String where, boolean forceSinglePass, double accuracy, int precision, int level, int max) {
        this(parentOfCopy, image, label, orderBy, outputs, children, aliases, hints, groupBy, null, where, forceSinglePass, accuracy, precision, level, max);
    }

    protected GroupingOperation(GroupingOperation parentOfCopy, String image, String label, List<GroupingExpression> orderBy, List<GroupingExpression> outputs, List<GroupingOperation> children, Map<String, GroupingExpression> aliases, Set<String> hints, GroupingExpression groupBy, FilterExpression filterBy, String where, boolean forceSinglePass, double accuracy, int precision, int level, int max) {
        super(image, label);
        this.parent = parentOfCopy;
        orderBy.forEach(item -> this.orderBy.add(item.copy()));
        outputs.forEach(item -> this.outputs.add(item.copy()));
        children.forEach(item -> this.children.add(item.copy(this)));
        aliases.forEach((key, value) -> this.aliases.put((String)key, value.copy()));
        this.hints.addAll(hints);
        if (groupBy != null) {
            this.groupBy = groupBy.copy();
        }
        if (filterBy != null) {
            this.filterBy = filterBy.copy();
        }
        this.where = where;
        this.forceSinglePass = forceSinglePass;
        this.accuracy = accuracy;
        this.precision = precision;
        this.level = level;
        this.max = max;
    }

    public abstract GroupingOperation copy(GroupingOperation var1);

    public GroupingOperation putAlias(String id, GroupingExpression exp) {
        this.aliases.put(id, exp);
        return this;
    }

    public GroupingExpression getAlias(String id) {
        if (this.aliases.containsKey(id)) {
            return this.aliases.get(id);
        }
        if (this.parent != null) {
            return this.parent.getAlias(id);
        }
        return null;
    }

    protected Map<String, GroupingExpression> getAliases() {
        return this.aliases;
    }

    public GroupingOperation addHint(String hint) {
        this.hints.add(hint);
        return this;
    }

    public boolean containsHint(String hint) {
        return this.hints.contains(hint);
    }

    public Set<String> getHints() {
        return Collections.unmodifiableSet(this.hints);
    }

    public GroupingOperation addChild(GroupingOperation op) {
        op.parent = this;
        this.children.add(op);
        return this;
    }

    public GroupingOperation addChildren(List<GroupingOperation> lst) {
        for (GroupingOperation op : lst) {
            this.addChild(op);
        }
        return this;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public GroupingOperation getChild(int i) {
        return this.children.get(i);
    }

    public List<GroupingOperation> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public GroupingOperation setGroupBy(GroupingExpression exp) {
        this.groupBy = exp;
        return this;
    }

    public GroupingExpression getGroupBy() {
        return this.groupBy;
    }

    @Beta
    public GroupingOperation setFilterBy(FilterExpression exp) {
        this.filterBy = Objects.requireNonNull(exp, "Filter expression can not be null");
        return this;
    }

    @Beta
    public FilterExpression getFilterBy() {
        return this.filterBy;
    }

    public int getLevel() {
        return this.level;
    }

    public void resolveLevel(int level) {
        if (this.groupBy != null) {
            if (level == 0) {
                throw new IllegalArgumentException("Operation '" + String.valueOf(this) + "' can not group " + GroupingOperation.getLevelDesc(level) + ".");
            }
            this.groupBy.resolveLevel(level - 1);
            ++level;
        }
        if (this.hasMax() && level == 0) {
            throw new IllegalArgumentException("Operation '" + String.valueOf(this) + "' can not apply max to " + GroupingOperation.getLevelDesc(level) + ".");
        }
        this.level = level;
        for (GroupingExpression exp : this.outputs) {
            exp.resolveLevel(level);
        }
        if (!this.orderBy.isEmpty()) {
            if (level == 0) {
                throw new IllegalArgumentException("Operation '" + String.valueOf(this) + "' can not order " + GroupingOperation.getLevelDesc(level) + ".");
            }
            for (GroupingExpression exp : this.orderBy) {
                exp.resolveLevel(level - 1);
            }
        }
        for (GroupingOperation child : this.children) {
            child.resolveLevel(level);
        }
    }

    protected GroupingOperation getParent() {
        return this.parent;
    }

    public GroupingOperation setForceSinglePass(boolean forceSinglePass) {
        this.forceSinglePass = forceSinglePass;
        return this;
    }

    public boolean getForceSinglePass() {
        return this.forceSinglePass;
    }

    public GroupingOperation setMax(int max) {
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public boolean hasMax() {
        return this.max >= 0;
    }

    @Beta
    public boolean hasUnlimitedMax() {
        return this.max == Integer.MAX_VALUE;
    }

    public GroupingOperation setAccuracy(double accuracy) {
        if (accuracy > 1.0 || accuracy < 0.0) {
            throw new IllegalArgumentException("Illegal accuracy '" + accuracy + "'. Must be between 0 and 1.");
        }
        this.accuracy = accuracy;
        return this;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public GroupingOperation addOrderBy(GroupingExpression exp) {
        this.orderBy.add(exp);
        return this;
    }

    public GroupingOperation addOrderBy(List<GroupingExpression> list) {
        for (GroupingExpression exp : list) {
            this.addOrderBy(exp);
        }
        return this;
    }

    public int getNumOrderBy() {
        return this.orderBy.size();
    }

    public GroupingExpression getOrderBy(int i) {
        return this.orderBy.get(i);
    }

    public List<GroupingExpression> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public GroupingOperation addOutput(GroupingExpression exp) {
        this.outputs.add(exp);
        return this;
    }

    public GroupingOperation addOutputs(List<GroupingExpression> lst) {
        for (GroupingExpression exp : lst) {
            this.addOutput(exp);
        }
        return this;
    }

    public int getNumOutputs() {
        return this.outputs.size();
    }

    public GroupingExpression getOutput(int i) {
        return this.outputs.get(i);
    }

    public List<GroupingExpression> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public GroupingOperation setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public int getPrecision() {
        return this.precision;
    }

    public GroupingOperation setWhere(String string) {
        this.where = string;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public void visitExpressions(ExpressionVisitor visitor) {
        for (GroupingExpression exp : this.aliases.values()) {
            exp.visit(visitor);
        }
        for (GroupingExpression exp : this.outputs) {
            exp.visit(visitor);
        }
        for (GroupingExpression exp : this.orderBy) {
            exp.visit(visitor);
        }
        if (this.groupBy != null) {
            this.groupBy.visit(visitor);
        }
        for (GroupingOperation op : this.children) {
            op.visitExpressions(visitor);
        }
    }

    @Override
    public GroupingOperation setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(super.toString()).append("(");
        if (this.groupBy != null) {
            ret.append("group(").append(this.groupBy).append(") ");
        }
        for (String hint : this.hints) {
            ret.append("hint(").append(hint).append(") ");
        }
        if (this.filterBy != null) {
            ret.append("filter(").append(this.filterBy).append(") ");
        }
        if (this.hasMax()) {
            ret.append("max(").append(this.max).append(") ");
        }
        if (!this.orderBy.isEmpty()) {
            ret.append("order(");
            ret.append(GroupingExpression.asString(this.orderBy));
            ret.append(") ");
        }
        if (!this.outputs.isEmpty()) {
            ret.append("output(");
            int len = this.outputs.size();
            for (int i = 0; i < len; ++i) {
                GroupingExpression exp = this.outputs.get(i);
                ret.append(exp);
                String label = exp.getLabel();
                if (label != null) {
                    ret.append(" as(").append(label).append(")");
                }
                if (i >= len - 1) continue;
                ret.append(", ");
            }
            ret.append(") ");
        }
        if (this.precision != 0) {
            ret.append("precision(").append(this.precision).append(") ");
        }
        if (this.where != null) {
            ret.append("where(").append(this.where).append(") ");
        }
        for (GroupingOperation child : this.children) {
            ret.append(child).append(" ");
        }
        int len = ret.length();
        if (ret.charAt(len - 1) == ' ') {
            ret.setLength(len - 1);
        }
        ret.append(")");
        String label = this.getLabel();
        if (label != null) {
            ret.append(" as(").append(label).append(")");
        }
        return ret.toString();
    }

    public static String getLevelDesc(int level) {
        if (level <= 0) {
            return "single hit";
        }
        if (level == 1) {
            return "single group";
        }
        return "list of ".repeat(level - 1) + "groups";
    }

    public static GroupingOperation fromString(String str) {
        List<GroupingOperation> lst = GroupingOperation.fromStringAsList(str);
        if (lst.size() != 1) {
            throw new IllegalArgumentException("Expected 1 operation, got " + lst.size() + ".");
        }
        return lst.get(0);
    }

    public static List<GroupingOperation> fromStringAsList(String string) {
        if (string == null || string.trim().isEmpty()) {
            return List.of();
        }
        GroupingParserInput input = new GroupingParserInput(string);
        try {
            return new GroupingParser(input).requestList();
        }
        catch (ParseException | TokenMgrException e) {
            throw new IllegalArgumentException(input.formatException(e.getMessage()), e);
        }
    }
}

