/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query.parser;

import com.yahoo.collections.Pair;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.AndSegmentItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.QueryCanonicalizer;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.TrueItem;
import com.yahoo.prelude.query.parser.SimpleParser;
import com.yahoo.prelude.query.parser.Token;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.QueryType;
import com.yahoo.search.query.parser.ParserEnvironment;
import java.util.ListIterator;

public class AllParser
extends SimpleParser {
    private final ParserEnvironment.ParserSettings parserSettings;

    public AllParser(ParserEnvironment environment) {
        super(environment);
        this.parserSettings = environment.getParserSettings();
    }

    @Override
    protected Item parseItems() {
        int position = this.tokens.getPosition();
        try {
            Item item = this.parseItemsBody();
            return item;
        }
        finally {
            this.tokens.setPosition(position);
        }
    }

    protected Item parseItemsBody() {
        CompositeItem and = null;
        NotItem not = null;
        do {
            Item current;
            if ((current = this.negativeItem()) != null) {
                not = this.addNot(current, not);
                continue;
            }
            current = this.positiveItem();
            if (current == null) {
                current = (Item)this.indexableItem("").getFirst();
            }
            if (current == null) {
                current = this.compositeItem();
            }
            if (current != null) {
                and = this.addAnd(current, and);
            }
            if (current != null) continue;
            this.tokens.skip();
        } while (this.tokens.hasNext());
        CompositeItem topLevel = and;
        if (not != null) {
            not.setPositiveItem(topLevel != null ? topLevel : new TrueItem());
            topLevel = not;
        }
        return this.simplifyUnnecessaryComposites(topLevel);
    }

    protected final Item simplifyUnnecessaryComposites(Item item) {
        if (item == null) {
            return null;
        }
        QueryTree root = new QueryTree(item);
        QueryCanonicalizer.canonicalize(root);
        return root.getRoot() instanceof NullItem ? null : root.getRoot();
    }

    private boolean foldIntoAnd(CompositeItem other) {
        if (other instanceof AndItem) {
            return !this.parserSettings.keepImplicitAnds();
        }
        if (this.weakAnd() && other instanceof AndSegmentItem) {
            AndSegmentItem sand = (AndSegmentItem)other;
            if (this.parserSettings.keepSegmentAnds()) {
                return false;
            }
            if (this.parserSettings.markSegmentAnds()) {
                sand.shouldFoldIntoWand(this.weakAnd());
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean weakAnd() {
        return this.environment.getType().getComposite() == QueryType.Composite.weakAnd;
    }

    protected CompositeItem addAnd(Item item, CompositeItem parent) {
        CompositeItem composite;
        if (parent == null) {
            parent = this.newComposite();
        }
        if (item instanceof CompositeItem && this.foldIntoAnd(composite = (CompositeItem)item)) {
            for (Item subItem : composite.items()) {
                this.addAnd(subItem, parent);
            }
        } else {
            parent.addItem(item);
        }
        return parent;
    }

    protected OrItem addOr(Item item, OrItem or) {
        if (or == null) {
            or = new OrItem();
        }
        or.addItem(item);
        return or;
    }

    protected NotItem addNot(Item item, NotItem not) {
        if (not == null) {
            not = new NotItem();
        }
        not.addNegativeItem(item);
        return not;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item negativeItem() {
        int position = this.tokens.getPosition();
        Item item = null;
        boolean isComposited = false;
        try {
            if (!this.tokens.skip(Token.Kind.MINUS)) {
                Item item2 = null;
                return item2;
            }
            if (this.tokens.currentIsNoIgnore(Token.Kind.SPACE)) {
                Item item3 = null;
                return item3;
            }
            Pair<Item, Boolean> itemAndExplicitIndex = this.indexableItem("");
            item = (Item)itemAndExplicitIndex.getFirst();
            boolean explicitIndex = (Boolean)itemAndExplicitIndex.getSecond();
            if (item == null && (item = this.compositeItem()) != null) {
                isComposited = true;
                if (item instanceof OrItem) {
                    CompositeItem and = this.newComposite();
                    ListIterator<Item> i = ((OrItem)item).getItemIterator();
                    while (i.hasNext()) {
                        and.addItem((Item)i.next());
                    }
                    item = and;
                }
            }
            if (item != null) {
                item.setProtected(true);
            }
            if (item instanceof IntItem && !explicitIndex && !isComposited && !((IntItem)item).getNumber().startsWith("-")) {
                item = null;
            }
            Item item4 = item;
            return item4;
        }
        finally {
            if (item == null) {
                this.tokens.setPosition(position);
            }
        }
    }

    @Override
    protected Item combineItems(Item topLevelItem, Item item) {
        if (topLevelItem == null) {
            return item;
        }
        if (topLevelItem instanceof OrItem && item instanceof OrItem) {
            OrItem newTopOr = new OrItem();
            newTopOr.addItem(topLevelItem);
            newTopOr.addItem(item);
            return newTopOr;
        }
        if (item instanceof OrItem && topLevelItem instanceof RankItem) {
            ListIterator<Item> i = ((RankItem)topLevelItem).getItemIterator();
            while (i.hasNext()) {
                ((OrItem)item).addItem(0, (Item)i.next());
            }
            return item;
        }
        if (item instanceof OrItem && topLevelItem instanceof PhraseItem) {
            OrItem newTopOr = new OrItem();
            newTopOr.addItem(topLevelItem);
            newTopOr.addItem(item);
            return newTopOr;
        }
        if (!(topLevelItem instanceof RankItem)) {
            RankItem rank = new RankItem();
            if (topLevelItem instanceof NotItem) {
                rank.addItem(topLevelItem);
                rank.addItem(item);
            } else {
                rank.addItem(item);
                rank.addItem(topLevelItem);
            }
            return rank;
        }
        if (item instanceof RankItem) {
            RankItem itemAsRank = (RankItem)item;
            if (((RankItem)item).getItem(0) instanceof OrItem) {
                OrItem or = (OrItem)itemAsRank.getItem(0);
                ((RankItem)topLevelItem).addItem(0, or);
                for (int i = 1; i < itemAsRank.getItemCount(); ++i) {
                    or.addItem(0, itemAsRank.getItem(i));
                }
                return topLevelItem;
            }
        }
        ((RankItem)topLevelItem).addItem(0, item);
        return topLevelItem;
    }
}

