/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NonReducibleCompositeItem;
import com.yahoo.protect.Validator;
import java.nio.ByteBuffer;
import java.util.Objects;

public class SameElementItem
extends NonReducibleCompositeItem {
    private String fieldName;

    public SameElementItem(String commonPath) {
        Validator.ensureNonEmpty((String)"Field name", (String)commonPath);
        this.fieldName = commonPath;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        SameElementItem.putString(this.fieldName, buffer);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.fieldName).append(':');
        buffer.append('{');
        super.appendBodyString(buffer);
        buffer.append('}');
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.SAME_ELEMENT;
    }

    @Override
    public String getName() {
        return this.getItemType().toString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void setIndexName(String index) {
        this.fieldName = index;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return Objects.equals(this.fieldName, ((SameElementItem)other).fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldName);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemSameElement.Builder builder = SearchProtocol.ItemSameElement.newBuilder();
        SearchProtocol.TermItemProperties.Builder props = SearchProtocol.TermItemProperties.newBuilder();
        props.setIndex(this.fieldName);
        builder.setProperties(props.build());
        for (Item child : this.items()) {
            builder.addChildren(child.toProtobuf());
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemSameElement(builder.build()).build();
    }
}

