/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.ranking;

import com.yahoo.search.result.FeatureData;
import com.yahoo.search.result.Hit;
import com.yahoo.tensor.Tensor;
import java.util.logging.Logger;

class WrappedHit
implements Comparable<WrappedHit> {
    private static final Logger logger = Logger.getLogger(WrappedHit.class.getName());
    private final Hit hit;
    private final FeatureData matchFeatures;
    private int idx = -1;
    private static final String RE_PREFIX = "rankingExpression(";
    private static final String RE_SUFFIX = ")";
    private static final int RE_PRE_LEN = "rankingExpression(".length();
    private static final int RE_SUF_LEN = ")".length();

    private WrappedHit(Hit hit, FeatureData matchFeatures) {
        this.hit = hit;
        this.matchFeatures = matchFeatures;
    }

    static WrappedHit from(Hit hit) {
        Object object = hit.getField("matchfeatures");
        if (object instanceof FeatureData) {
            FeatureData mf = (FeatureData)object;
            return new WrappedHit(hit, mf);
        }
        return null;
    }

    double getScore() {
        return this.hit.getRelevance().getScore();
    }

    void setScore(double value) {
        this.hit.setRelevance(value);
    }

    int getIdx() {
        if (this.idx < 0) {
            throw new IllegalStateException("Missing index");
        }
        return this.idx;
    }

    void setIdx(int value) {
        if (this.idx == value) {
            return;
        }
        if (this.idx >= 0) {
            throw new IllegalArgumentException("Cannot re-assign index " + this.idx + " -> " + value);
        }
        this.idx = value;
    }

    @Override
    public int compareTo(WrappedHit other) {
        return this.hit.compareTo(other.hit);
    }

    Tensor getTensor(String argName) {
        Tensor asTensor = this.matchFeatures.getTensor(argName);
        if (asTensor == null) {
            asTensor = this.matchFeatures.getTensor(WrappedHit.alternate(argName));
        }
        return asTensor;
    }

    static String alternate(String argName) {
        if (argName.startsWith(RE_PREFIX) && argName.endsWith(RE_SUFFIX)) {
            return argName.substring(RE_PRE_LEN, argName.length() - RE_SUF_LEN);
        }
        return RE_PREFIX + argName + RE_SUFFIX;
    }
}

