/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.search.query.textserialize.item.AndNotRestConverter;
import com.yahoo.search.query.textserialize.item.CompositeConverter;
import com.yahoo.search.query.textserialize.item.ExactStringConverter;
import com.yahoo.search.query.textserialize.item.IntConverter;
import com.yahoo.search.query.textserialize.item.ItemFormConverter;
import com.yahoo.search.query.textserialize.item.NearConverter;
import com.yahoo.search.query.textserialize.item.PrefixConverter;
import com.yahoo.search.query.textserialize.item.SubStringConverter;
import com.yahoo.search.query.textserialize.item.SuffixConverter;
import com.yahoo.search.query.textserialize.item.WordConverter;
import java.util.HashMap;
import java.util.Map;

public class ItemExecutorRegistry {
    private static final Map<String, ItemFormConverter> executorsByName = new HashMap<String, ItemFormConverter>();

    private static <T extends CompositeItem> ItemFormConverter createCompositeConverter(Class<T> itemClass) {
        return new CompositeConverter<T>(itemClass);
    }

    private static void register(Item.ItemType type, ItemFormConverter executor) {
        ItemExecutorRegistry.register(type.toString(), executor);
    }

    private static void register(String type, ItemFormConverter executor) {
        executorsByName.put(type, executor);
    }

    public static ItemFormConverter getByName(String name) {
        ItemFormConverter executor = executorsByName.get(name);
        ItemExecutorRegistry.ensureNotNull(executor, name);
        return executor;
    }

    private static void ensureNotNull(ItemFormConverter executor, String name) {
        if (executor == null) {
            throw new RuntimeException("No item type named '" + name + "'.");
        }
    }

    public static ItemFormConverter getByType(Item.ItemType itemType) {
        String name = itemType == Item.ItemType.NOT ? "AND-NOT-REST" : itemType.name();
        return ItemExecutorRegistry.getByName(name);
    }

    static {
        ItemExecutorRegistry.register(Item.ItemType.AND, ItemExecutorRegistry.createCompositeConverter(AndItem.class));
        ItemExecutorRegistry.register(Item.ItemType.OR, ItemExecutorRegistry.createCompositeConverter(OrItem.class));
        ItemExecutorRegistry.register(Item.ItemType.RANK, ItemExecutorRegistry.createCompositeConverter(RankItem.class));
        ItemExecutorRegistry.register(Item.ItemType.PHRASE, ItemExecutorRegistry.createCompositeConverter(PhraseItem.class));
        ItemExecutorRegistry.register(Item.ItemType.EQUIV, ItemExecutorRegistry.createCompositeConverter(EquivItem.class));
        ItemExecutorRegistry.register("AND-NOT-REST", (ItemFormConverter)new AndNotRestConverter());
        ItemExecutorRegistry.register(Item.ItemType.NEAR, (ItemFormConverter)new NearConverter((Class<? extends NearItem>)NearItem.class));
        ItemExecutorRegistry.register(Item.ItemType.ONEAR, (ItemFormConverter)new NearConverter((Class<? extends NearItem>)ONearItem.class));
        ItemExecutorRegistry.register(Item.ItemType.WORD, (ItemFormConverter)new WordConverter());
        ItemExecutorRegistry.register(Item.ItemType.INT, (ItemFormConverter)new IntConverter());
        ItemExecutorRegistry.register(Item.ItemType.PREFIX, (ItemFormConverter)new PrefixConverter());
        ItemExecutorRegistry.register(Item.ItemType.SUBSTRING, (ItemFormConverter)new SubStringConverter());
        ItemExecutorRegistry.register(Item.ItemType.EXACT, (ItemFormConverter)new ExactStringConverter());
        ItemExecutorRegistry.register(Item.ItemType.SUFFIX, (ItemFormConverter)new SuffixConverter());
    }
}

