/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Type;
import com.yahoo.data.access.slime.SlimeAdapter;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.schema.DocumentSummary;
import com.yahoo.search.schema.Schema;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class DocsumDefinitionSet {
    public static final int SLIME_MAGIC_ID = 0x55555555;
    private final Map<String, DocsumDefinition> definitionsByName;

    public DocsumDefinitionSet(Schema schema) {
        this(schema.documentSummaries().values());
    }

    public DocsumDefinitionSet(Collection<DocumentSummary> docsumDefinitions) {
        ConcurrentMap<String, DocsumDefinition> map = docsumDefinitions.stream().map(DocsumDefinition::new).collect(Collectors.toConcurrentMap(DocsumDefinition::name, summary -> summary));
        map.computeIfAbsent("[all]", k -> new DocsumDefinition((String)k, (DocsumDefinition)map.get("default"), map.values()));
        this.definitionsByName = Map.copyOf(map);
    }

    public DocsumDefinition getDocsum(String summaryClass) {
        DocsumDefinition ds;
        if (summaryClass == null || summaryClass.isEmpty()) {
            summaryClass = "default";
        }
        if ((ds = this.definitionsByName.get(summaryClass)) == null) {
            ds = this.definitionsByName.get("default");
        }
        if (ds == null) {
            throw new ConfigurationException("Fetched hit with summary class " + summaryClass + ", but this summary class is not in current summary config (" + String.valueOf(this) + ") (that is, you asked for something unknown, and no default was found)");
        }
        return ds;
    }

    public boolean hasDocsum(String summaryClass) {
        if (summaryClass == null || summaryClass.isEmpty()) {
            summaryClass = "default";
        }
        return this.definitionsByName.containsKey(summaryClass);
    }

    public String lazyDecode(String summaryClass, byte[] data, FastHit hit) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        long docsumClassId = buffer.getInt();
        if (docsumClassId != 0x55555555L) {
            throw new IllegalArgumentException("Only expecting SchemaLess docsums - summary class:" + summaryClass + " hit:" + String.valueOf(hit));
        }
        DocsumDefinition docsumDefinition = this.getDocsum(summaryClass);
        Slime value = BinaryFormat.decode((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)buffer.remaining());
        SlimeAdapter docsum = new SlimeAdapter((Inspector)value.get());
        if (docsum.type() != Type.OBJECT) {
            return "Hit " + String.valueOf(hit) + " failed: " + docsum.asString();
        }
        hit.addSummary(docsumDefinition, (com.yahoo.data.access.Inspector)docsum);
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, DocsumDefinition> e : this.definitionsByName.entrySet()) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append("[").append(e.getKey()).append(",").append(e.getValue().name()).append("]");
        }
        return sb.toString();
    }

    public int size() {
        return this.definitionsByName.size();
    }
}

