/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.FreezableComponent;
import com.yahoo.search.pagetemplates.PlaceholderMappingVisitor;
import com.yahoo.search.pagetemplates.PlaceholderReferenceCreatingVisitor;
import com.yahoo.search.pagetemplates.SourceVisitor;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import com.yahoo.search.pagetemplates.model.Section;
import com.yahoo.search.pagetemplates.model.Source;
import java.util.Collections;
import java.util.Set;

public final class PageTemplate
extends FreezableComponent
implements PageElement {
    private Section section = new Section();
    private Set<Source> sources = null;

    public PageTemplate(ComponentId id) {
        super(id);
    }

    public void setSection(Section section) {
        this.ensureNotFrozen();
        this.section = section;
    }

    public Section getSection() {
        return this.section;
    }

    public Set<Source> getSources() {
        if (this.isFrozen()) {
            return this.sources;
        }
        SourceVisitor sourceVisitor = new SourceVisitor();
        this.getSection().accept(sourceVisitor);
        return Collections.unmodifiableSet(sourceVisitor.getSources());
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        this.resolvePlaceholders();
        this.section.freeze();
        this.sources = this.getSources();
        super.freeze();
    }

    private void resolvePlaceholders() {
        try {
            PlaceholderMappingVisitor placeholderMappingVisitor = new PlaceholderMappingVisitor();
            this.accept(placeholderMappingVisitor);
            this.accept(new PlaceholderReferenceCreatingVisitor(placeholderMappingVisitor.getMap()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(this) + " is invalid", e);
        }
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
        this.section.accept(visitor);
    }

    public String toString() {
        return "page template '" + String.valueOf(this.getId()) + "'";
    }
}

