/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import org.apache.commons.math3.distribution.TDistribution;

public class TopKEstimator {
    private final TDistribution studentT;
    private final double defaultP;
    private final boolean estimate;
    private final double skewFactor;
    private final double[] defaultCumulativeProbability;
    private static final int MIN_N = 2;

    private static boolean needEstimate(double p) {
        return 0.0 < p && p < 1.0;
    }

    TopKEstimator(double freedom, double defaultProbability) {
        this(freedom, defaultProbability, 0.0);
    }

    public TopKEstimator(double freedom, double defaultProbability, double skewFactor) {
        this.studentT = new TDistribution(null, freedom);
        this.defaultP = defaultProbability;
        this.estimate = TopKEstimator.needEstimate(this.defaultP);
        this.skewFactor = skewFactor;
        this.defaultCumulativeProbability = new double[64];
        for (int i = 0; i < this.defaultCumulativeProbability.length; ++i) {
            this.defaultCumulativeProbability[i] = this.computeCumulativeProbability(i + 2, this.defaultP);
        }
    }

    private double inverseCumulativeProbability(int n, double p) {
        if (p == this.defaultP && n >= 2 && n < this.defaultCumulativeProbability.length + 2) {
            return this.defaultCumulativeProbability[n - 2];
        }
        return this.computeCumulativeProbability(n, p);
    }

    private double computeCumulativeProbability(int n, double p) {
        double p_inverse = 1.0 - (1.0 - p) / this.computeN(n);
        return this.studentT.inverseCumulativeProbability(p_inverse);
    }

    private double computeN(double n) {
        double p_max = (1.0 + this.skewFactor) / n;
        return Math.max(1.0, 1.0 / p_max);
    }

    double estimateExactK(double k, int n_i, double p) {
        double n = this.computeN(n_i);
        double variance = k * 1.0 / n * (1.0 - 1.0 / n);
        return k / n + this.inverseCumulativeProbability(n_i, p) * Math.sqrt(variance);
    }

    double estimateExactK(double k, int n) {
        return this.estimateExactK(k, n, this.defaultP);
    }

    public int estimateK(int k, int n) {
        return this.estimate && n >= 2 ? Math.min(k, (int)Math.ceil(this.estimateExactK(k, n, this.defaultP))) : k;
    }

    public int estimateK(int k, int n, double p) {
        return TopKEstimator.needEstimate(p) && n >= 2 ? Math.min(k, (int)Math.ceil(this.estimateExactK(k, n, p))) : k;
    }
}

