/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SimpleTaggableItem;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Objects;

public class NearestNeighborItem
extends SimpleTaggableItem {
    private int targetNumHits = 0;
    private int hnswExploreAdditionalHits = 0;
    private double distanceThreshold = Double.POSITIVE_INFINITY;
    private boolean approximate = true;
    private String field;
    private final String queryTensorName;
    private Double hnswApproximateThreshold = null;
    private Double hnswExplorationSlack = null;
    private Double hnswFilterFirstExploration = null;
    private Double hnswFilterFirstThreshold = null;
    private Double hnswPostFilterThreshold = null;
    private Double hnswTargetHitsMaxAdjustmentFactor = null;

    public NearestNeighborItem(String fieldName, String queryTensorName) {
        this.field = fieldName;
        this.queryTensorName = queryTensorName;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public String getIndexName() {
        return this.field;
    }

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public int getHnswExploreAdditionalHits() {
        return this.hnswExploreAdditionalHits;
    }

    public boolean getAllowApproximate() {
        return this.approximate;
    }

    public String getQueryTensorName() {
        return this.queryTensorName;
    }

    public Double getHnswApproximateThreshold() {
        return this.hnswApproximateThreshold;
    }

    public Double getHnswExplorationSlack() {
        return this.hnswExplorationSlack;
    }

    public Double getHnswFilterFirstExploration() {
        return this.hnswFilterFirstExploration;
    }

    public Double getHnswFilterFirstThreshold() {
        return this.hnswFilterFirstThreshold;
    }

    public Double getHnswPostFilterThreshold() {
        return this.hnswPostFilterThreshold;
    }

    public Double getHnswTargetHitsMaxAdjustmentFactor() {
        return this.hnswTargetHitsMaxAdjustmentFactor;
    }

    public void setTargetNumHits(int target) {
        this.targetNumHits = target;
    }

    public void setDistanceThreshold(double threshold) {
        this.distanceThreshold = threshold;
    }

    public void setHnswExploreAdditionalHits(int num) {
        this.hnswExploreAdditionalHits = num;
    }

    public void setAllowApproximate(boolean value) {
        this.approximate = value;
    }

    public void setHnswApproximateThreshold(Double value) {
        this.hnswApproximateThreshold = value;
    }

    public void setHnswExplorationSlack(Double value) {
        this.hnswExplorationSlack = value;
    }

    public void setHnswFilterFirstExploration(Double value) {
        this.hnswFilterFirstExploration = value;
    }

    public void setHnswFilterFirstThreshold(Double value) {
        this.hnswFilterFirstThreshold = value;
    }

    public void setHnswPostFilterThreshold(Double value) {
        this.hnswPostFilterThreshold = value;
    }

    public void setHnswTargetHitsMaxAdjustmentFactor(Double value) {
        this.hnswTargetHitsMaxAdjustmentFactor = value;
    }

    @Override
    public void setIndexName(String index) {
        this.field = index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAREST_NEIGHBOR;
    }

    @Override
    public String getName() {
        return "NEAREST_NEIGHBOR";
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        super.encodeThis(buffer);
        NearestNeighborItem.putString(this.field, buffer);
        NearestNeighborItem.putString(this.queryTensorName, buffer);
        int approxNum = this.approximate ? 1 : 0;
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)approxNum, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.hnswExploreAdditionalHits, (ByteBuffer)buffer);
        buffer.putDouble(this.distanceThreshold);
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append("{field=").append(this.field);
        buffer.append(",queryTensorName=").append(this.queryTensorName);
        buffer.append(",hnsw.exploreAdditionalHits=").append(this.hnswExploreAdditionalHits);
        buffer.append(",distanceThreshold=").append(this.distanceThreshold);
        buffer.append(",approximate=").append(this.approximate);
        buffer.append(",targetHits=").append(this.targetNumHits);
        if (this.hnswApproximateThreshold != null) {
            buffer.append(",hnsw.approximateThreshold=").append(this.hnswApproximateThreshold);
        }
        if (this.hnswExplorationSlack != null) {
            buffer.append(",hnsw.explorationSlack=").append(this.hnswExplorationSlack);
        }
        if (this.hnswFilterFirstExploration != null) {
            buffer.append(",hnsw.filterFirstExploration=").append(this.hnswFilterFirstExploration);
        }
        if (this.hnswFilterFirstThreshold != null) {
            buffer.append(",hnsw.filterFirstThreshold=").append(this.hnswFilterFirstThreshold);
        }
        if (this.hnswPostFilterThreshold != null) {
            buffer.append(",hnsw.postFilterThreshold=").append(this.hnswPostFilterThreshold);
        }
        if (this.hnswTargetHitsMaxAdjustmentFactor != null) {
            buffer.append(",hnsw.targetHitsMaxAdjustmentFactor=").append(this.hnswTargetHitsMaxAdjustmentFactor);
        }
        buffer.append("}");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("field", this.field);
        discloser.addProperty("queryTensorName", this.queryTensorName);
        discloser.addProperty("hnsw.exploreAdditionalHits", this.hnswExploreAdditionalHits);
        discloser.addProperty("distanceThreshold", this.distanceThreshold);
        discloser.addProperty("approximate", this.approximate);
        discloser.addProperty("targetHits", this.targetNumHits);
        if (this.hnswApproximateThreshold != null) {
            discloser.addProperty("hnsw.approximateThreshold", this.hnswApproximateThreshold);
        }
        if (this.hnswExplorationSlack != null) {
            discloser.addProperty("hnsw.explorationSlack", this.hnswExplorationSlack);
        }
        if (this.hnswFilterFirstExploration != null) {
            discloser.addProperty("hnsw.filterFirstExploration", this.hnswFilterFirstExploration);
        }
        if (this.hnswFilterFirstThreshold != null) {
            discloser.addProperty("hnsw.filterFirstThreshold", this.hnswFilterFirstThreshold);
        }
        if (this.hnswPostFilterThreshold != null) {
            discloser.addProperty("hnsw.postFilterThreshold", this.hnswPostFilterThreshold);
        }
        if (this.hnswTargetHitsMaxAdjustmentFactor != null) {
            discloser.addProperty("hnsw.targetHitsMaxAdjustmentFactor", this.hnswTargetHitsMaxAdjustmentFactor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        NearestNeighborItem other = (NearestNeighborItem)o;
        if (this.targetNumHits != other.targetNumHits) {
            return false;
        }
        if (this.hnswExploreAdditionalHits != other.hnswExploreAdditionalHits) {
            return false;
        }
        if (this.distanceThreshold != other.distanceThreshold) {
            return false;
        }
        if (this.approximate != other.approximate) {
            return false;
        }
        if (!this.field.equals(other.field)) {
            return false;
        }
        if (!this.queryTensorName.equals(other.queryTensorName)) {
            return false;
        }
        if (!Objects.equals(this.hnswApproximateThreshold, other.hnswApproximateThreshold)) {
            return false;
        }
        if (!Objects.equals(this.hnswExplorationSlack, other.hnswExplorationSlack)) {
            return false;
        }
        if (!Objects.equals(this.hnswFilterFirstExploration, other.hnswFilterFirstExploration)) {
            return false;
        }
        if (!Objects.equals(this.hnswFilterFirstThreshold, other.hnswFilterFirstThreshold)) {
            return false;
        }
        if (!Objects.equals(this.hnswPostFilterThreshold, other.hnswPostFilterThreshold)) {
            return false;
        }
        return Objects.equals(this.hnswTargetHitsMaxAdjustmentFactor, other.hnswTargetHitsMaxAdjustmentFactor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetNumHits, this.hnswExploreAdditionalHits, this.distanceThreshold, this.approximate, this.field, this.queryTensorName, this.hnswApproximateThreshold, this.hnswExplorationSlack, this.hnswFilterFirstExploration, this.hnswFilterFirstThreshold, this.hnswPostFilterThreshold, this.hnswTargetHitsMaxAdjustmentFactor);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemNearestNeighbor.Builder builder = SearchProtocol.ItemNearestNeighbor.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setQueryTensorName(this.queryTensorName);
        builder.setTargetNumHits(this.targetNumHits);
        builder.setAllowApproximate(this.approximate);
        builder.setExploreAdditionalHits(this.hnswExploreAdditionalHits);
        builder.setDistanceThreshold(this.distanceThreshold);
        if (this.hnswApproximateThreshold != null) {
            builder.setApproximateThreshold(this.hnswApproximateThreshold.doubleValue());
        }
        if (this.hnswExplorationSlack != null) {
            builder.setExplorationSlack(this.hnswExplorationSlack.doubleValue());
        }
        if (this.hnswFilterFirstExploration != null) {
            builder.setFilterFirstExploration(this.hnswFilterFirstExploration.doubleValue());
        }
        if (this.hnswFilterFirstThreshold != null) {
            builder.setFilterFirstThreshold(this.hnswFilterFirstThreshold.doubleValue());
        }
        if (this.hnswPostFilterThreshold != null) {
            builder.setPostFilterThreshold(this.hnswPostFilterThreshold.doubleValue());
        }
        if (this.hnswTargetHitsMaxAdjustmentFactor != null) {
            builder.setTargetHitsMaxAdjustmentFactor(this.hnswTargetHitsMaxAdjustmentFactor.doubleValue());
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemNearestNeighbor(builder.build()).build();
    }
}

