/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.result.Group;
import com.yahoo.search.grouping.result.GroupList;
import com.yahoo.search.grouping.result.HitList;
import com.yahoo.search.query.context.QueryContext;
import com.yahoo.search.rendering.Renderer;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SectionedRenderer<WRITER>
extends Renderer {
    public WRITER wrapWriter(Writer writer) {
        return (WRITER)writer;
    }

    public abstract void beginResult(WRITER var1, Result var2) throws IOException;

    public abstract void endResult(WRITER var1, Result var2) throws IOException;

    public abstract void error(WRITER var1, Collection<com.yahoo.search.result.ErrorMessage> var2) throws IOException;

    public abstract void emptyResult(WRITER var1, Result var2) throws IOException;

    public abstract void queryContext(WRITER var1, QueryContext var2) throws IOException;

    public abstract void beginHitGroup(WRITER var1, HitGroup var2) throws IOException;

    public abstract void endHitGroup(WRITER var1, HitGroup var2) throws IOException;

    public abstract void hit(WRITER var1, Hit var2) throws IOException;

    public void errorHit(WRITER writer, ErrorHit errorHit) throws IOException {
        this.hit(writer, (Hit)((Object)errorHit));
    }

    public void beginGroup(WRITER writer, Group group) throws IOException {
        this.beginHitGroup(writer, group);
    }

    public void endGroup(WRITER writer, Group group) throws IOException {
        this.endHitGroup(writer, group);
    }

    public void beginGroupList(WRITER writer, GroupList groupList) throws IOException {
        this.beginHitGroup(writer, groupList);
    }

    public void endGroupList(WRITER writer, GroupList groupList) throws IOException {
        this.endHitGroup(writer, groupList);
    }

    public void beginHitList(WRITER writer, HitList hitList) throws IOException {
        this.beginHitGroup(writer, hitList);
    }

    public void endHitList(WRITER writer, HitList hitList) throws IOException {
        this.endHitGroup(writer, hitList);
    }

    @Override
    public final void render(Writer writer, Result result) throws IOException {
        WRITER wrappedWriter = this.wrapWriter(writer);
        this.beginResult(wrappedWriter, result);
        this.renderResultContent(wrappedWriter, result);
        this.endResult(wrappedWriter, result);
    }

    private void renderResultContent(WRITER writer, Result result) throws IOException {
        if (result.hits().getError() != null || !result.hits().getQuery().errors().isEmpty()) {
            this.error(writer, this.asUnmodifiableSearchErrorList(result.hits().getQuery().errors(), result.hits().getError()));
        }
        if (result.getConcreteHitCount() == 0) {
            this.emptyResult(writer, result);
        }
        if (result.getContext(false) != null) {
            this.queryContext(writer, result.getContext(false));
        }
        this.renderHitGroup(writer, result.hits());
    }

    private Collection<com.yahoo.search.result.ErrorMessage> asUnmodifiableSearchErrorList(List<ErrorMessage> queryErrors, com.yahoo.search.result.ErrorMessage resultError) {
        if (queryErrors.isEmpty()) {
            return List.of(resultError);
        }
        ArrayList<com.yahoo.search.result.ErrorMessage> searchErrors = new ArrayList<com.yahoo.search.result.ErrorMessage>(queryErrors.size() + (resultError != null ? 1 : 0));
        for (ErrorMessage queryError : queryErrors) {
            searchErrors.add(com.yahoo.search.result.ErrorMessage.from(queryError));
        }
        if (resultError != null) {
            searchErrors.add(resultError);
        }
        return List.copyOf(searchErrors);
    }

    private void renderHitGroup(WRITER writer, HitGroup hitGroup) throws IOException {
        if (hitGroup instanceof GroupList) {
            this.beginGroupList(writer, (GroupList)hitGroup);
            this.renderHitGroupContent(writer, hitGroup);
            this.endGroupList(writer, (GroupList)hitGroup);
        } else if (hitGroup instanceof HitList) {
            this.beginHitList(writer, (HitList)hitGroup);
            this.renderHitGroupContent(writer, hitGroup);
            this.endHitList(writer, (HitList)hitGroup);
        } else if (hitGroup instanceof Group) {
            this.beginGroup(writer, (Group)hitGroup);
            this.renderHitGroupContent(writer, hitGroup);
            this.endGroup(writer, (Group)hitGroup);
        } else {
            this.beginHitGroup(writer, hitGroup);
            this.renderHitGroupContent(writer, hitGroup);
            this.endHitGroup(writer, hitGroup);
        }
    }

    private void renderHitGroupContent(WRITER writer, HitGroup hitGroup) throws IOException {
        for (Hit hit : hitGroup.asList()) {
            this.renderHit(writer, hit);
        }
    }

    private void renderHit(WRITER writer, Hit hit) throws IOException {
        if (hit instanceof HitGroup) {
            this.renderHitGroup(writer, (HitGroup)hit);
        } else if (hit instanceof ErrorHit) {
            this.errorHit(writer, (ErrorHit)((Object)hit));
        } else {
            this.hit(writer, hit);
        }
    }
}

